/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.base64;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import org.rascalmpl.util.base64.Base64CharWriter;

public class Base64EncodingOutputStream
extends OutputStream {
    private final Base64.Encoder encoder;
    private final Base64CharWriter target;
    private static final int ENC_INPUT_SIZE = 3072;
    private static final int ENC_OUTPUT_SIZE = 4096;
    private boolean closed = false;
    private byte[] buffer = new byte[3072];
    private int written = 0;

    public Base64EncodingOutputStream(Base64CharWriter writer, boolean padding) {
        this.encoder = padding ? Base64.getEncoder() : Base64.getEncoder().withoutPadding();
        this.target = writer;
    }

    private void actualFlush() throws IOException {
        int available;
        byte[] toWrite;
        if (this.written != 3072) {
            toWrite = new byte[(this.written / 3 + 2) * 4];
            available = this.encoder.encode(Arrays.copyOf(this.buffer, this.written), toWrite);
        } else {
            toWrite = new byte[4096];
            available = this.encoder.encode(this.buffer, toWrite);
        }
        this.written = 0;
        this.target.write(toWrite, available);
    }

    private void flushIfNeeded() throws IOException {
        if (this.written == 3072) {
            this.actualFlush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.written++] = (byte)(b & 0xFF);
        this.flushIfNeeded();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int copied = 0;
        while (copied < len) {
            int toWrite = Math.min(len - copied, 3072 - this.written);
            System.arraycopy(b, off + copied, this.buffer, this.written, toWrite);
            copied += toWrite;
            this.written += toWrite;
            this.flushIfNeeded();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.actualFlush();
        this.target.close();
    }

    public static void direct(InputStream source, Base64CharWriter target, boolean padding) throws IOException {
        int read;
        Base64.Encoder encoder = padding ? Base64.getEncoder() : Base64.getEncoder().withoutPadding();
        byte[] inputBuffer = new byte[3072];
        byte[] outputBuffer = new byte[4096];
        do {
            int blockRead;
            for (read = 0; read != 3072 && (blockRead = source.read(inputBuffer, read, 3072 - read)) != -1; read += blockRead) {
            }
            if (read == 0) {
                return;
            }
            if (read != inputBuffer.length) {
                inputBuffer = Arrays.copyOf(inputBuffer, read);
            }
            int toWrite = encoder.encode(inputBuffer, outputBuffer);
            target.write(outputBuffer, toWrite);
        } while (read == 3072);
    }
}

