/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.library.Messages;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.Dependency;
import org.rascalmpl.util.maven.MavenMessages;
import org.rascalmpl.util.maven.MavenParser;
import org.rascalmpl.util.maven.Scope;
import org.rascalmpl.util.maven.SimpleResolver;
import org.rascalmpl.values.IRascalValueFactory;

public class Artifact {
    private final ArtifactCoordinate coordinate;
    private final @Nullable ArtifactCoordinate parentCoordinate;
    private final @Nullable Path resolved;
    private final List<Dependency> dependencies;
    private final @Nullable SimpleResolver ourResolver;
    private IList messages;
    private final boolean anyError;
    private final @Nullable Dependency origin;

    private Artifact(ArtifactCoordinate coordinate, @Nullable ArtifactCoordinate parentCoordinate, Dependency origin, @Nullable Path resolved, List<Dependency> dependencies, IList messages, @Nullable SimpleResolver originalResolver) {
        this.coordinate = coordinate;
        this.parentCoordinate = parentCoordinate;
        this.origin = origin;
        this.resolved = resolved;
        this.dependencies = dependencies;
        this.messages = messages;
        this.ourResolver = originalResolver;
        this.anyError = messages.stream().anyMatch(Messages::isError);
    }

    private Artifact(Artifact original, String version) {
        ArtifactCoordinate coord = original.coordinate;
        this.coordinate = new ArtifactCoordinate(coord.getGroupId(), coord.getArtifactId(), version, coord.getClassifier());
        this.parentCoordinate = original.parentCoordinate;
        this.origin = original.origin;
        this.resolved = original.resolved;
        this.dependencies = original.dependencies;
        this.messages = original.messages;
        this.ourResolver = original.ourResolver;
        this.anyError = original.anyError;
    }

    public ArtifactCoordinate getCoordinate() {
        return this.coordinate;
    }

    public @Nullable ArtifactCoordinate getParentCoordinate() {
        return this.parentCoordinate;
    }

    public boolean hasErrors() {
        return this.anyError;
    }

    public IList getMessages() {
        return this.messages;
    }

    public Dependency getOrigin() {
        return this.origin;
    }

    public @Nullable Path getResolved() {
        return this.resolved;
    }

    List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Artifact> resolveDependencies(Scope forScope, MavenParser parser) {
        ArrayList<Artifact> result = new ArrayList<Artifact>(this.dependencies.size());
        LinkedList<ResolveState> resolveQueue = new LinkedList<ResolveState>();
        resolveQueue.add(new ResolveState(this, Collections.emptySet()));
        Artifact.calculateClassPath(forScope, resolveQueue, result, parser);
        return result;
    }

    private static boolean isVersionRange(String version) {
        return version != null && (version.startsWith("[") || version.startsWith("("));
    }

    private static void calculateClassPath(Scope forScope, Queue<ResolveState> resolveQueue, ArrayList<Artifact> result, MavenParser parser) {
        HashSet<ResolveKey> alreadyResolved = new HashSet<ResolveKey>();
        HashMap<ArtifactCoordinate.WithoutVersion, String> resolvedVersions = new HashMap<ArtifactCoordinate.WithoutVersion, String>();
        HashMap<ArtifactCoordinate.WithoutVersion, SortedSet> rangedDeps = new HashMap<ArtifactCoordinate.WithoutVersion, SortedSet>();
        boolean topLevel = true;
        while (!resolveQueue.isEmpty()) {
            ResolveState state = resolveQueue.poll();
            Artifact artifact = state.artifact;
            for (Dependency d : artifact.dependencies) {
                Artifact art;
                boolean resolved;
                ArtifactCoordinate coordinate = d.getCoordinate();
                ArtifactCoordinate.WithoutVersion versionLess = coordinate.versionLess();
                String version = coordinate.getVersion();
                if (Artifact.isVersionRange(version)) {
                    try {
                        version = artifact.ourResolver.findLatestMatchingVersion(coordinate.getGroupId(), coordinate.getArtifactId(), version);
                        coordinate = new ArtifactCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), version, coordinate.getClassifier());
                    }
                    catch (UnresolvableModelException e) {
                        artifact.messages = artifact.messages.append(MavenMessages.error("Version range error: " + e.getMessage(), d));
                        continue;
                    }
                    SortedSet versions = rangedDeps.computeIfAbsent(versionLess, k -> new TreeSet());
                    if (versions.add(version) && versions.size() == 2) {
                        String effectiveVersion = (String)versions.first();
                        artifact.messages = artifact.messages.append(MavenMessages.warning("Multiple version ranges found for " + versionLess + " are used. It is better to lock the desired version in your own pom to a specifick version, for example <version>[" + effectiveVersion + "]</version>", d));
                    }
                }
                if (!d.shouldInclude(forScope) || !topLevel && d.getScope() == Scope.PROVIDED) continue;
                String resolvedVersion = (String)resolvedVersions.get(versionLess);
                boolean bl = resolved = resolvedVersion != null;
                if (resolved) {
                    coordinate = new ArtifactCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), resolvedVersion, coordinate.getClassifier());
                } else {
                    resolvedVersions.put(versionLess, version);
                }
                ResolveKey key = new ResolveKey(coordinate, state.exclusions);
                if (alreadyResolved.contains(key)) continue;
                alreadyResolved.add(key);
                if (d.getScope() == Scope.SYSTEM) {
                    if (resolved) continue;
                    result.add(Artifact.createSystemArtifact(d));
                    continue;
                }
                Set<ArtifactCoordinate.WithoutVersion> newExclusions = state.exclusions;
                if (!d.getExclusions().isEmpty()) {
                    if (state.exclusions.isEmpty()) {
                        newExclusions = d.getExclusions();
                    } else {
                        newExclusions = new HashSet<ArtifactCoordinate.WithoutVersion>(newExclusions);
                        newExclusions.addAll(d.getExclusions());
                    }
                }
                if ((art = parser.parseArtifact(coordinate, newExclusions = Set.copyOf(newExclusions), d, artifact.ourResolver)) == null) continue;
                if (!resolved) {
                    result.add(art);
                }
                resolveQueue.add(new ResolveState(art, newExclusions));
            }
            topLevel = false;
            if (forScope != Scope.TEST) continue;
            forScope = Scope.COMPILE;
        }
    }

    private static Artifact createSystemArtifact(Dependency d) {
        IListWriter messages = IRascalValueFactory.getInstance().listWriter();
        String systemPath = d.getSystemPath();
        Path path = null;
        if (systemPath == null) {
            messages.append(MavenMessages.error("system dependency " + d + " without a systemPath property", d));
        } else {
            path = Path.of(systemPath, new String[0]);
            if (Files.notExists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
                messages.append(MavenMessages.error("systemPath property (of" + d + ") points to a file that does not exist (or is not a regular file): " + systemPath, d));
                path = null;
            }
        }
        return new Artifact(d.getCoordinate(), null, d, path, Collections.emptyList(), (IList)messages.done(), null);
    }

    private static boolean isJarPackaging(String packaging) {
        return packaging.equals("jar") || packaging.equals("eclipse-plugin") || packaging.equals("maven-plugin") || packaging.equals("bundle");
    }

    static @Nullable Artifact build(Model m4, Dependency origin, boolean isRoot, Path pom, ISourceLocation pomLocation, String classifier, Set<ArtifactCoordinate.WithoutVersion> exclusions, IListWriter messages, SimpleResolver resolver) {
        String packaging = m4.getPackaging();
        if (packaging != null && !Artifact.isJarPackaging(packaging)) {
            return null;
        }
        ArtifactCoordinate coordinate = new ArtifactCoordinate(m4.getGroupId(), m4.getArtifactId(), m4.getVersion(), classifier);
        Parent parent = m4.getParent();
        ArtifactCoordinate parentCoordinate = parent == null ? null : new ArtifactCoordinate(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), "");
        try {
            Path loc = isRoot ? null : resolver.resolveJar(coordinate);
            List<Dependency> dependencies = packaging != null && packaging.equals("bundle") ? Collections.emptyList() : m4.getDependencies().stream().filter(d -> !"import".equals(d.getScope())).filter(d -> !exclusions.contains(ArtifactCoordinate.versionLess(d.getGroupId(), d.getArtifactId()))).map(d -> {
                if (d.getVersion() == null) {
                    InputLocation depLoc = d.getLocation("");
                    messages.append(MavenMessages.error("Dependency " + d.getGroupId() + ":" + d.getArtifactId() + " is missing a version", pomLocation, depLoc.getLineNumber(), depLoc.getColumnNumber()));
                }
                return Dependency.build(d, pomLocation);
            }).collect(Collectors.toUnmodifiableList());
            return new Artifact(coordinate, parentCoordinate, origin, loc, dependencies, (IList)messages.done(), resolver);
        }
        catch (UnresolvableModelException e) {
            messages.append(MavenMessages.error("Could not download corresponding jar", origin));
            return new Artifact(coordinate, parentCoordinate, origin, null, Collections.emptyList(), (IList)messages.done(), resolver);
        }
    }

    static Artifact unresolved(ArtifactCoordinate coordinate, Dependency origin, IListWriter messages) {
        return new Artifact(coordinate, null, origin, null, Collections.emptyList(), (IList)messages.done(), null);
    }

    public String toString() {
        return this.coordinate + "[" + (this.resolved != null ? "resolved" : "missing") + "]";
    }

    public void report(PrintWriter target) {
        target.append("coordinate: ");
        target.append(this.coordinate.toString());
        target.append("\n");
        target.append("parent: ");
        target.append(this.parentCoordinate == null ? "null" : this.parentCoordinate.toString());
        target.append("\n");
        target.append("resolved: ");
        target.append(this.resolved == null ? "null" : this.resolved.toString());
        target.append("\n");
        target.append("dependencies (unresolved):\n");
        for (Dependency d : this.dependencies) {
            target.append("- ");
            target.append(d.toString());
            target.append("\n");
        }
        target.append("messsages:\n");
        Messages.write(this.messages, target);
    }

    private static class ResolveState {
        private final Artifact artifact;
        private final Set<ArtifactCoordinate.WithoutVersion> exclusions;

        public ResolveState(Artifact artifact, Set<ArtifactCoordinate.WithoutVersion> exclusions) {
            this.artifact = artifact;
            this.exclusions = exclusions;
        }
    }

    private static class ResolveKey {
        private final @NonNull String groupId;
        private final @NonNull String artifactId;
        private final @NonNull Set<ArtifactCoordinate.WithoutVersion> excludes;

        public ResolveKey(ArtifactCoordinate coordinate, Set<ArtifactCoordinate.WithoutVersion> excludes) {
            this.groupId = coordinate.getGroupId();
            this.artifactId = coordinate.getArtifactId();
            this.excludes = excludes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            result = 31 * result + this.excludes.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResolveKey)) {
                return false;
            }
            ResolveKey other = (ResolveKey)obj;
            return this.groupId.equals(other.groupId) && this.artifactId.equals(other.artifactId) && this.excludes.equals(other.excludes);
        }
    }
}

