/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ArtifactCoordinate {
    public static final ArtifactCoordinate UNKNOWN = new ArtifactCoordinate("unkown", "unknown", "?", "");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;

    ArtifactCoordinate(String groupId, String artifactId, String version, @Nullable String classifier) {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier == null ? "" : classifier;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    WithoutVersion versionLess() {
        return new WithoutVersion(this);
    }

    static WithoutVersion versionLess(String groupId, String artifactId) {
        return new WithoutVersion(new ArtifactCoordinate(groupId, artifactId, "???", ""));
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + (String)(this.classifier.isEmpty() ? "" : ":" + this.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtifactCoordinate)) {
            return false;
        }
        ArtifactCoordinate other = (ArtifactCoordinate)obj;
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.version, other.version) && Objects.equals(this.classifier, other.classifier);
    }

    static class WithoutVersion {
        private final ArtifactCoordinate base;

        public WithoutVersion(ArtifactCoordinate base) {
            this.base = base;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WithoutVersion)) {
                return false;
            }
            ArtifactCoordinate otherBase = ((WithoutVersion)obj).base;
            return this.base.groupId.equals(otherBase.groupId) && this.base.artifactId.equals(otherBase.artifactId);
        }

        public int hashCode() {
            return this.base.groupId.hashCode() + this.base.artifactId.hashCode() * 11;
        }

        public String toString() {
            return this.base.getGroupId() + ":" + this.base.getArtifactId();
        }
    }
}

