/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.rascalmpl.util.maven.Repo;
import org.rascalmpl.util.maven.RepositoryDownloader;

public abstract class BaseRepositoryDownloader
implements RepositoryDownloader {
    private static final String PROP_LAST_UPDATED = "lastUpdated";
    private static final long MAX_INFO_AGE = 43200000L;
    private final Repo repo;

    public BaseRepositoryDownloader(Repo repo) {
        this.repo = repo;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    protected URI createUri(String url, String suffix) throws URISyntaxException {
        if (url.endsWith("/") && suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        return new URI(url + suffix);
    }

    protected void ensureTargetDirectoryExists(Path target) throws IOException {
        Path directory = target.getParent();
        if (Files.notExists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    @Override
    public @Nullable Metadata downloadMetadata(String url, Path target) {
        Properties info;
        int dotIndex;
        String source = null;
        String fileName = target.getFileName().toString();
        String infoFilename = fileName.substring(0, dotIndex = fileName.lastIndexOf(46)) + "-info.properties";
        Path infoPath = target.resolveSibling(infoFilename);
        if (Files.exists(infoPath, new LinkOption[0])) {
            info = new Properties();
            try {
                info.load(Files.newBufferedReader(infoPath));
                long lastUpdated = Long.parseLong(info.getProperty(PROP_LAST_UPDATED, "0"));
                if (System.currentTimeMillis() - lastUpdated < 43200000L) {
                    source = Files.readString(target);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (source == null) {
            source = this.downloadAndRead(url, target, true);
            if (source == null) {
                return null;
            }
            info = new Properties();
            info.setProperty(PROP_LAST_UPDATED, String.valueOf(System.currentTimeMillis()));
            try {
                info.store(Files.newBufferedWriter(infoPath, new OpenOption[0]), "Metadata info for " + fileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            return reader.read(new StringReader(source));
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }
}

