/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class ChecksumInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final MessageDigest sha1Digest;
    private final MessageDigest md5Digest;

    public ChecksumInputStream(InputStream inputStream) {
        this.wrappedStream = inputStream;
        try {
            this.sha1Digest = MessageDigest.getInstance("SHA1");
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.wrappedStream.read();
        if (byteRead != -1) {
            this.sha1Digest.update((byte)byteRead);
            this.md5Digest.update((byte)byteRead);
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.wrappedStream.read(b, off, len);
        if (bytesRead != -1) {
            this.sha1Digest.update(b, off, bytesRead);
            this.md5Digest.update(b, off, bytesRead);
        }
        return bytesRead;
    }

    private String getChecksum(MessageDigest digest) {
        StringBuilder sb = new StringBuilder();
        for (byte b : digest.digest()) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public String getSha1Checksum() {
        return this.getChecksum(this.sha1Digest);
    }

    public String getMd5Checksum() {
        return this.getChecksum(this.md5Digest);
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
        this.sha1Digest.reset();
        this.md5Digest.reset();
    }
}

