/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.util.maven.BaseRepositoryDownloader;
import org.rascalmpl.util.maven.Repo;

public class FileRepositoryDownloader
extends BaseRepositoryDownloader {
    public FileRepositoryDownloader(Repo repo) {
        super(repo);
    }

    private InputStream getInputStream(String path) throws IOException {
        try {
            return this.createUri(this.getRepo().getUrl(), path).toURL().openStream();
        }
        catch (IOException | URISyntaxException e) {
            throw new IOException("Could not open stream for " + path + " in repo " + this.getRepo().getUrl(), e);
        }
    }

    @Override
    public boolean download(String path, Path target, boolean force) {
        try {
            this.ensureTargetDirectoryExists(target);
            InputStream inputStream = this.getInputStream(path);
            if (force || !Files.exists(target, new LinkOption[0])) {
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public @Nullable String downloadAndRead(String path, Path target, boolean force) {
        try {
            this.ensureTargetDirectoryExists(target);
            InputStream inputStream = this.getInputStream(path);
            byte[] bytes = inputStream.readAllBytes();
            if (force || !Files.exists(target, new LinkOption[0])) {
                Files.write(target, bytes, new OpenOption[0]);
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }
}

