/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.util.maven.Artifact;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.Dependency;
import org.rascalmpl.util.maven.MavenMessages;
import org.rascalmpl.util.maven.MavenProxySelector;
import org.rascalmpl.util.maven.MavenSettings;
import org.rascalmpl.util.maven.ModelResolutionError;
import org.rascalmpl.util.maven.Scope;
import org.rascalmpl.util.maven.SimpleResolver;
import org.rascalmpl.util.maven.SimpleWorkspaceResolver;
import org.rascalmpl.values.IRascalValueFactory;

public class MavenParser {
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private final Path projectPom;
    private final ISourceLocation projectPomLocation;
    private final ModelBuilder builder;
    private final HttpClient httpClient;
    private final ModelCache modelCache;
    private final List<IValue> settingMessages;
    private final SimpleResolver rootResolver;

    public MavenParser(Path projectPom) {
        this(MavenSettings.readSettings(), projectPom);
    }

    MavenParser(MavenSettings settings, Path projectPom) {
        this(settings, projectPom, settings.getLocalRepository());
    }

    MavenParser(MavenSettings settings, Path projectPom, Path rootMavenRepo) {
        this.projectPom = projectPom;
        try {
            this.projectPomLocation = URIUtil.createFileLocation(projectPom);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Project pom is an illegal path", e);
        }
        this.settingMessages = new ArrayList<IValue>();
        MavenProxySelector proxySelector = new MavenProxySelector(settings.getProxies(), this.settingMessages);
        this.builder = new DefaultModelBuilderFactory().newInstance();
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).proxy(proxySelector).build();
        this.modelCache = new CaffeineModelCache();
        this.rootResolver = SimpleResolver.createRootResolver(rootMavenRepo, this.httpClient, settings.getMirrors(), settings.getServerSettings());
    }

    public Artifact parseProject() throws ModelResolutionError {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setPomFile(this.projectPom.toFile());
        SimpleResolver resolver = this.rootResolver.createChildResolver();
        IListWriter messages = VF.listWriter();
        messages.appendAll(this.settingMessages);
        Model model = this.getBestModel(this.projectPomLocation, request, resolver, messages);
        if (model == null) {
            throw new ModelResolutionError(messages);
        }
        Artifact result = null;
        if (model.getGroupId() != null && model.getVersion() != null) {
            result = Artifact.build(model, null, true, this.projectPom, this.projectPomLocation, "", Collections.emptySet(), messages, resolver);
        }
        if (result == null) {
            return Artifact.unresolved(new ArtifactCoordinate(Objects.requireNonNullElse(model.getGroupId(), ""), model.getArtifactId(), Objects.requireNonNullElse(model.getVersion(), ""), ""), null, messages);
        }
        return result;
    }

    @Nullable Artifact parseArtifact(ArtifactCoordinate coordinate, Set<ArtifactCoordinate.WithoutVersion> exclusions, Dependency origin, SimpleResolver originalResolver) {
        IListWriter messages = VF.listWriter();
        try {
            ModelSource modelSource = originalResolver.resolveModel(coordinate);
            ISourceLocation pomLocation = MavenParser.calculateLocation(modelSource);
            Path pomPath = Path.of(pomLocation.getURI());
            SimpleResolver resolver = originalResolver.createChildResolver();
            SimpleWorkspaceResolver workspaceResolver = new SimpleWorkspaceResolver(originalResolver, this.builder, this);
            ModelBuildingRequest request = new DefaultModelBuildingRequest().setModelSource(modelSource).setWorkspaceModelResolver(workspaceResolver);
            Model model = this.getBestModel(pomLocation, request, resolver, messages);
            if (model == null) {
                return Artifact.unresolved(coordinate, origin, messages);
            }
            return Artifact.build(model, origin, false, pomPath, pomLocation, coordinate.getClassifier(), exclusions, messages, resolver);
        }
        catch (UnresolvableModelException e) {
            messages.append(MavenMessages.error("Could not resolve " + coordinate + ". " + e.getMessage(), origin));
            return Artifact.unresolved(coordinate, origin, messages);
        }
    }

    private static ISourceLocation calculateLocation(ModelSource source) {
        try {
            URI loc = source instanceof ModelSource2 ? ((ModelSource2)source).getLocationURI() : new URI(source.getLocation());
            return VF.sourceLocation(URIUtil.fixUnicode(loc));
        }
        catch (URISyntaxException e) {
            return URIUtil.unknownLocation();
        }
    }

    private @Nullable Model getBestModel(ISourceLocation pom, ModelBuildingRequest request, ModelResolver resolver, IListWriter messages) {
        try {
            ModelBuildingResult result = this.buildModel(request, resolver);
            this.translateProblems(result.getProblems(), pom, messages);
            return result.getEffectiveModel();
        }
        catch (ModelBuildingException be) {
            this.translateProblems(be.getProblems(), pom, messages);
            return be.getModel();
        }
    }

    private void translateProblems(List<ModelProblem> problems, ISourceLocation loc, IListWriter messages) {
        block4: for (ModelProblem problem : problems) {
            String message = problem.getMessage();
            int line = Math.max(0, problem.getLineNumber());
            int column = Math.max(0, problem.getColumnNumber());
            switch (problem.getSeverity()) {
                case ERROR: 
                case FATAL: {
                    messages.append(MavenMessages.error(message, loc, line, column));
                    continue block4;
                }
                case WARNING: {
                    messages.append(MavenMessages.warning(message, loc, line, column));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Missing case: " + problem.getSeverity());
        }
    }

    public Model buildEffectiveModel(ModelBuildingRequest request, ModelResolver resolver) throws ModelBuildingException {
        return this.buildModel(request, resolver).getEffectiveModel();
    }

    private ModelBuildingResult buildModel(ModelBuildingRequest request, ModelResolver resolver) throws ModelBuildingException {
        request.setModelResolver(resolver).setModelCache(this.modelCache).setLocationTracking(true).setValidationLevel(0).setSystemProperties(System.getProperties());
        return this.builder.build(request);
    }

    private static void test(Path target) throws ModelResolutionError {
        long start = System.currentTimeMillis();
        MavenParser parser = new MavenParser(new MavenSettings(), target);
        Artifact project = parser.parseProject();
        long stop = System.currentTimeMillis();
        PrintWriter out = new PrintWriter(System.out);
        project.report(out);
        out.printf("It took %d ms to resolve root artifact%n", stop - start);
        start = System.currentTimeMillis();
        List<Artifact> deps = project.resolveDependencies(Scope.COMPILE, parser);
        stop = System.currentTimeMillis();
        out.println(deps);
        out.printf("It took %d ms to resolve dependencies%n", stop - start);
        out.flush();
    }

    public static void main(String[] args) {
        try {
            MavenParser.test(Path.of("C:/Users/Davy/swat.engineering/rascal/rascal/test/org/rascalmpl/util/maven/poms/multi-module/example-core/pom.xml", new String[0]));
            System.out.println("******");
            System.out.println("******");
            System.out.println("******");
            MavenParser.test(Path.of("pom.xml", new String[0]).toAbsolutePath());
        }
        catch (Throwable t2) {
            System.err.println("Caught: " + t2);
            t2.printStackTrace();
        }
    }

    private static final class CaffeineModelCache
    implements ModelCache {
        private final Cache<Key, Object> modelCache = Caffeine.newBuilder().maximumSize(100L).build();

        private CaffeineModelCache() {
        }

        @Override
        public void put(String groupId, String artifactId, String version, String tag, Object data) {
            this.modelCache.put(new Key(groupId, artifactId, version, tag), data);
        }

        @Override
        public Object get(String groupId, String artifactId, String version, String tag) {
            return this.modelCache.getIfPresent(new Key(groupId, artifactId, version, tag));
        }

        private static final class Key {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String tag;

            public Key(String groupId, String artifactId, String version, String tag) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.tag = tag;
            }

            public int hashCode() {
                return this.groupId.hashCode() + this.artifactId.hashCode() * 7 + this.version.hashCode() * 11 + this.tag.hashCode() * 13;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof Key)) {
                    return false;
                }
                Key other = (Key)obj;
                return this.groupId.equals(other.groupId) && this.artifactId.equals(other.artifactId) && this.version.equals(other.version) && this.tag.equals(other.tag);
            }
        }
    }
}

