/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.io.File;
import java.net.URI;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.rascalmpl.util.maven.MavenParser;
import org.rascalmpl.util.maven.SimpleResolver;

class SimpleWorkspaceResolver
implements WorkspaceModelResolver {
    private final SimpleResolver resolver;
    private final ModelBuilder builder;
    private final MavenParser parser;

    public SimpleWorkspaceResolver(SimpleResolver resolver, ModelBuilder builder, MavenParser parser) {
        this.resolver = resolver;
        this.builder = builder;
        this.parser = parser;
    }

    @Override
    public Model resolveRawModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        URI location = ((ModelSource2)this.resolver.resolveModel(groupId, artifactId, versionConstraint)).getLocationURI();
        if (!location.getScheme().equals("file")) {
            throw new UnresolvableModelException("Could not locate model on disk", groupId, artifactId, versionConstraint);
        }
        Result<? extends Model> result = this.builder.buildRawModel(new File(location), 0, false);
        if (result.get() == null) {
            throw new UnresolvableModelException("Could not build raw model", groupId, artifactId, versionConstraint);
        }
        return result.get();
    }

    @Override
    public Model resolveEffectiveModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        ModelSource location = this.resolver.resolveModel(groupId, artifactId, versionConstraint);
        ModelBuildingRequest request = new DefaultModelBuildingRequest().setModelSource(location).setWorkspaceModelResolver(this);
        try {
            return this.parser.buildEffectiveModel(request, this.resolver);
        }
        catch (ModelBuildingException e) {
            throw new UnresolvableModelException(e, groupId, artifactId, versionConstraint);
        }
    }
}

