/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.visualize.dot;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.rascalmpl.util.visualize.dot.CompassPoint;
import org.rascalmpl.util.visualize.dot.DotAttribute;
import org.rascalmpl.util.visualize.dot.DotStatement;
import org.rascalmpl.util.visualize.dot.NodeId;

public class DotEdge
implements DotStatement {
    private NodeId from;
    private List<NodeId> to;
    private boolean directed;
    private List<DotAttribute> attributes;

    public DotEdge(NodeId from) {
        this(from, true);
    }

    public DotEdge(NodeId from, boolean directed) {
        this.from = from;
        this.directed = directed;
        this.to = new ArrayList<NodeId>();
        this.attributes = new ArrayList<DotAttribute>();
    }

    public DotEdge(NodeId from, NodeId ... to) {
        this(from, true, to);
    }

    public DotEdge(NodeId from, boolean directed, NodeId ... to) {
        this(from, directed);
        for (NodeId node : to) {
            this.addTo(node);
        }
    }

    public void addTo(NodeId node) {
        this.to.add(node);
    }

    public void addAttribute(String property, String value) {
        this.attributes.add(new DotAttribute(property, value));
    }

    @Override
    public void writeSource(PrintWriter writer) {
        this.from.writeSource(writer);
        for (NodeId node : this.to) {
            if (this.directed) {
                writer.write(" -> ");
            } else {
                writer.write(" -- ");
            }
            node.writeSource(writer);
        }
        DotAttribute.writeAttributes(writer, this.attributes);
    }

    public static DotEdge createArrayEdge(NodeId array, int index, NodeId element) {
        return new DotEdge(new NodeId(array, String.valueOf(index)), true, element);
    }

    public static DotEdge createArrayEdge(NodeId array, int index, CompassPoint direction, NodeId element) {
        return new DotEdge(new NodeId(array.getId(), String.valueOf(index), direction), true, element);
    }
}

