/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.iterators;

import io.usethesource.vallang.IValue;
import java.util.Iterator;
import org.rascalmpl.exceptions.ImplementationError;

public class SingleIValueIterator
implements Iterator<IValue> {
    private IValue value;
    private boolean firstCall;

    public SingleIValueIterator(IValue value) {
        this.value = value;
        this.firstCall = true;
    }

    @Override
    public boolean hasNext() {
        return this.firstCall;
    }

    @Override
    public IValue next() {
        if (!this.firstCall) {
            throw new ImplementationError("next called more than once");
        }
        this.firstCall = false;
        return this.value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove for SingleIValueIterator");
    }
}

