/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.parsetrees;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.Iterator;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class SymbolAdapter {
    private static final IValueFactory VF = ValueFactoryFactory.getValueFactory();

    private SymbolAdapter() {
    }

    public static IConstructor delabel(IConstructor sym) {
        if (SymbolAdapter.isLabel(sym)) {
            return (IConstructor)sym.get(1);
        }
        return sym;
    }

    public static IConstructor stripLabelsAndConditions(IConstructor sym) {
        boolean label = false;
        boolean cond = false;
        while ((label = SymbolAdapter.isLabel(sym)) || (cond = SymbolAdapter.isConditional(sym))) {
            if (label) {
                sym = SymbolAdapter.delabel(sym);
                continue;
            }
            if (!cond) continue;
            sym = SymbolAdapter.getSymbol(sym);
        }
        return sym;
    }

    public static boolean isLabel(IConstructor sym) {
        return sym.getConstructorType() == RascalValueFactory.Symbol_Label;
    }

    public static int indexOfLabel(IList syms, String name) {
        for (int i = 0; i < syms.length(); ++i) {
            IConstructor sym = (IConstructor)syms.get(i);
            while (SymbolAdapter.isConditional(sym)) {
                sym = SymbolAdapter.getSymbol(sym);
            }
            if (!SymbolAdapter.isLabel(sym) || !SymbolAdapter.getLabel(sym).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isSort(IConstructor tree) {
        return (tree = SymbolAdapter.delabel(tree)).getConstructorType() == RascalValueFactory.Symbol_Sort;
    }

    public static boolean isMeta(IConstructor tree) {
        return (tree = SymbolAdapter.delabel(tree)).getConstructorType() == RascalValueFactory.Symbol_Meta;
    }

    public static boolean isStartSort(IConstructor tree) {
        return (tree = SymbolAdapter.delabel(tree)).getConstructorType() == RascalValueFactory.Symbol_Start;
    }

    public static IConstructor getStart(IConstructor tree) {
        if (SymbolAdapter.isStartSort(tree)) {
            tree = SymbolAdapter.delabel(tree);
            return (IConstructor)tree.get(0);
        }
        throw new ImplementationError("Symbol does not have a child named symbol: " + tree);
    }

    public static IConstructor getLabeledSymbol(IConstructor tree) {
        return (IConstructor)tree.get("symbol");
    }

    public static IConstructor getSymbol(IConstructor tree) {
        if (SymbolAdapter.isOpt(tree = SymbolAdapter.delabel(tree)) || SymbolAdapter.isIterPlus(tree) || SymbolAdapter.isIterStar(tree) || SymbolAdapter.isIterPlusSeps(tree) || SymbolAdapter.isIterStarSeps(tree) || SymbolAdapter.isMeta(tree) || SymbolAdapter.isConditional(tree)) {
            return (IConstructor)tree.get(0);
        }
        throw new ImplementationError("Symbol does not have a child named symbol: " + tree);
    }

    public static boolean isConditional(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Symbol_Conditional;
    }

    public static String getLabelName(IConstructor tree) {
        return ((IString)tree.get("name")).getValue();
    }

    public static String getName(IConstructor tree) {
        tree = SymbolAdapter.delabel(tree);
        return ((IString)tree.get("name")).getValue();
    }

    public static String getLabel(IConstructor tree) {
        if (SymbolAdapter.isLabel(tree)) {
            return ((IString)tree.get("name")).getValue();
        }
        throw new ImplementationError("Symbol does not have a child named \"label\" : " + tree);
    }

    public static boolean isParameterizedSort(IConstructor tree) {
        return (tree = SymbolAdapter.delabel(tree)).getConstructorType() == RascalValueFactory.Symbol_ParameterizedSort;
    }

    public static boolean isParameterizedLex(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Symbol_ParameterizedLex;
    }

    public static boolean isLiteral(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Symbol_Lit;
    }

    public static boolean isCILiteral(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Symbol_Cilit;
    }

    public static boolean isIterStar(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Symbol_IterStar;
    }

    public static boolean isIterPlus(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Symbol_Iter;
    }

    public static boolean isLayouts(IConstructor tree) {
        return tree.getConstructorType() == RascalValueFactory.Symbol_Layouts;
    }

    public static boolean isStarList(IConstructor tree) {
        return SymbolAdapter.isIterStar(tree = SymbolAdapter.delabel(tree)) || SymbolAdapter.isIterStarSeps(tree);
    }

    public static boolean isPlusList(IConstructor tree) {
        return SymbolAdapter.isIterPlus(tree = SymbolAdapter.delabel(tree)) || SymbolAdapter.isIterPlusSeps(tree);
    }

    public static boolean isSepList(IConstructor tree) {
        return SymbolAdapter.isIterPlusSeps(tree = SymbolAdapter.delabel(tree)) || SymbolAdapter.isIterStarSeps(tree);
    }

    public static boolean isAnyList(IConstructor tree) {
        return SymbolAdapter.isStarList(tree = SymbolAdapter.delabel(tree)) || SymbolAdapter.isPlusList(tree);
    }

    public static boolean isOpt(IConstructor tree) {
        return SymbolAdapter.delabel(tree).getConstructorType() == RascalValueFactory.Symbol_Opt;
    }

    public static boolean isSequence(IConstructor tree) {
        return SymbolAdapter.delabel(tree).getConstructorType() == RascalValueFactory.Symbol_Seq;
    }

    public static boolean isAlternative(IConstructor tree) {
        return SymbolAdapter.delabel(tree).getConstructorType() == RascalValueFactory.Symbol_Alt;
    }

    public static String toString(IConstructor symbol, boolean withLayout) {
        if (SymbolAdapter.isLabel(symbol)) {
            return SymbolAdapter.toString((IConstructor)symbol.get("symbol"), withLayout) + " " + ((IString)symbol.get("name")).getValue();
        }
        if (SymbolAdapter.isSort(symbol) || SymbolAdapter.isLex(symbol) || SymbolAdapter.isKeyword(symbol)) {
            return SymbolAdapter.getName(symbol);
        }
        if (SymbolAdapter.isEmpty(symbol)) {
            return "()";
        }
        if (SymbolAdapter.isCharClass(symbol)) {
            IConstructor complement = SymbolAdapter.complementCharClass(symbol);
            if (SymbolAdapter.getRanges(complement).length() >= SymbolAdapter.getRanges(symbol).length()) {
                return SymbolAdapter.charClassToString(symbol);
            }
            return "!" + SymbolAdapter.charClassToString(complement);
        }
        if (SymbolAdapter.isIterPlusSeps(symbol)) {
            IList seps = SymbolAdapter.getSeparators(symbol);
            StringBuilder b = new StringBuilder();
            if (!withLayout && seps.length() == 1 && SymbolAdapter.isLayouts((IConstructor)seps.get(0))) {
                b.append(SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout));
                b.append('+');
            } else {
                b.append('{');
                b.append(SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout));
                for (IValue sep : seps) {
                    b.append(" ");
                    b.append(SymbolAdapter.toString((IConstructor)sep, withLayout));
                }
                b.append('}');
                b.append('+');
            }
            return b.toString();
        }
        if (SymbolAdapter.isIterStarSeps(symbol)) {
            StringBuilder b = new StringBuilder();
            IList seps = SymbolAdapter.getSeparators(symbol);
            if (!withLayout && seps.length() == 1 && SymbolAdapter.isLayouts((IConstructor)seps.get(0))) {
                b.append(SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout));
                b.append('*');
            } else {
                b.append('{');
                b.append(SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout));
                for (IValue sep : seps) {
                    if (SymbolAdapter.isLayouts((IConstructor)sep)) continue;
                    b.append(" ");
                    b.append(SymbolAdapter.toString((IConstructor)sep, withLayout));
                }
                b.append('}');
                b.append('*');
            }
            return b.toString();
        }
        if (SymbolAdapter.isIterPlus(symbol)) {
            return SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout) + "+";
        }
        if (SymbolAdapter.isIterStar(symbol)) {
            return SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout) + "*";
        }
        if (SymbolAdapter.isOpt(symbol)) {
            return SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout) + "?";
        }
        if (SymbolAdapter.isSeq(symbol)) {
            return "(" + SymbolAdapter.toString(SymbolAdapter.getSymbols(symbol), ' ', withLayout) + ")";
        }
        if (SymbolAdapter.isAlt(symbol)) {
            ISet alts = SymbolAdapter.getAlternatives(symbol);
            StringBuilder b = new StringBuilder();
            b.append("(");
            boolean first = true;
            for (IValue elem : alts) {
                if (!first) {
                    first = false;
                    b.append(" | ");
                }
                b.append(SymbolAdapter.toString((IConstructor)elem, withLayout));
            }
            b.append(")");
            return b.toString();
        }
        if (SymbolAdapter.isLayouts(symbol)) {
            return withLayout ? "layout[" + symbol.get("name") + "]" : "";
        }
        if (SymbolAdapter.isLiteral(symbol)) {
            return "\"" + ((IString)symbol.get("string")).getValue() + "\"";
        }
        if (SymbolAdapter.isCILiteral(symbol)) {
            return "'" + ((IString)symbol.get("string")).getValue() + "'";
        }
        if (SymbolAdapter.isParameterizedSort(symbol) || SymbolAdapter.isParameterizedLex(symbol)) {
            StringBuilder b = new StringBuilder();
            b.append(SymbolAdapter.getName(symbol));
            IList params = (IList)symbol.get("parameters");
            b.append('[');
            b.append(SymbolAdapter.toString(params, ',', withLayout));
            b.append(']');
            return b.toString();
        }
        if (SymbolAdapter.isStartSort(symbol)) {
            return "start[" + SymbolAdapter.toString(SymbolAdapter.getStart(symbol), withLayout) + "]";
        }
        if (SymbolAdapter.isParameter(symbol)) {
            return "&" + SymbolAdapter.getName(symbol);
        }
        if (SymbolAdapter.isInt(symbol) || SymbolAdapter.isStr(symbol) || SymbolAdapter.isReal(symbol) || SymbolAdapter.isBool(symbol) || SymbolAdapter.isRat(symbol) || SymbolAdapter.isNode(symbol) || SymbolAdapter.isValue(symbol) || SymbolAdapter.isVoid(symbol) || SymbolAdapter.isNum(symbol) || SymbolAdapter.isDatetime(symbol) || SymbolAdapter.isLoc(symbol)) {
            return symbol.getName();
        }
        if (SymbolAdapter.isSet(symbol) || SymbolAdapter.isList(symbol) || SymbolAdapter.isBag(symbol) || SymbolAdapter.isReifiedType(symbol)) {
            return symbol.getName() + "[" + SymbolAdapter.toString((IConstructor)symbol.get("symbol"), withLayout) + "]";
        }
        if (SymbolAdapter.isRel(symbol) || SymbolAdapter.isListRel(symbol) || SymbolAdapter.isTuple(symbol)) {
            StringBuilder b = new StringBuilder();
            b.append(symbol.getName());
            IList symbols = (IList)symbol.get("symbols");
            b.append('[');
            b.append(SymbolAdapter.toString(symbols, ',', withLayout));
            b.append(']');
            return b.toString();
        }
        if (SymbolAdapter.isMap(symbol)) {
            return symbol.getName() + "[" + SymbolAdapter.toString((IConstructor)symbol.get("from"), withLayout) + "," + SymbolAdapter.toString((IConstructor)symbol.get("to"), withLayout) + "]";
        }
        if (SymbolAdapter.isConditional(symbol)) {
            IConstructor cond;
            ISet conditions = SymbolAdapter.getConditions(symbol);
            StringBuilder b = new StringBuilder();
            for (IValue elem : conditions) {
                cond = (IConstructor)elem;
                switch (cond.getConstructorType().getName()) {
                    case "precede": {
                        b.append(SymbolAdapter.toString((IConstructor)cond.get("symbol"), withLayout));
                        b.append(" << ");
                        break;
                    }
                    case "not-precede": {
                        b.append(SymbolAdapter.toString((IConstructor)cond.get("symbol"), withLayout));
                        b.append(" !<< ");
                        break;
                    }
                    case "begin-of-line": {
                        b.append("^ ");
                    }
                }
            }
            b.append(SymbolAdapter.toString(SymbolAdapter.getSymbol(symbol), withLayout));
            for (IValue elem : conditions) {
                cond = (IConstructor)elem;
                switch (cond.getConstructorType().getName()) {
                    case "follow": {
                        b.append(" >> ");
                        b.append(SymbolAdapter.toString((IConstructor)cond.get("symbol"), withLayout));
                        break;
                    }
                    case "not-follow": {
                        b.append(" !>> ");
                        b.append(SymbolAdapter.toString((IConstructor)cond.get("symbol"), withLayout));
                        break;
                    }
                    case "delete": {
                        b.append(" \\ ");
                        b.append(SymbolAdapter.toString((IConstructor)cond.get("symbol"), withLayout));
                        break;
                    }
                    case "except": {
                        b.append("!");
                        b.append(((IString)cond.get("label")).getValue());
                    }
                    case "end-of-line": {
                        b.append(" $");
                    }
                }
            }
            return b.toString();
        }
        if (SymbolAdapter.isADT(symbol) || SymbolAdapter.isAlias(symbol)) {
            StringBuilder b = new StringBuilder();
            b.append(SymbolAdapter.getName(symbol));
            IList params = (IList)symbol.get("parameters");
            if (!params.isEmpty()) {
                b.append('[');
                b.append(SymbolAdapter.toString(params, ',', withLayout));
                b.append(']');
            }
            return b.toString();
        }
        if (SymbolAdapter.isFunc(symbol)) {
            StringBuilder b = new StringBuilder();
            b.append(SymbolAdapter.toString((IConstructor)symbol.get("ret"), withLayout));
            b.append("(");
            b.append(SymbolAdapter.toString((IList)symbol.get("parameters"), ',', withLayout));
            b.append(")");
            return b.toString();
        }
        if (SymbolAdapter.isCons(symbol)) {
            StringBuilder b = new StringBuilder();
            b.append(SymbolAdapter.toString((IConstructor)symbol.get("adt"), withLayout));
            b.append(" ");
            b.append(((IString)symbol.get("name")).getValue());
            b.append("(");
            b.append(SymbolAdapter.toString((IList)symbol.get("parameters"), ',', withLayout));
            b.append(")");
        }
        return symbol.toString();
    }

    private static String charClassToString(IConstructor symbol) {
        IList ranges = SymbolAdapter.getRanges(symbol);
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (IValue range : ranges) {
            IInteger to;
            IInteger from = SymbolAdapter.getRangeBegin(range);
            if (from.equals(to = SymbolAdapter.getRangeEnd(range))) {
                b.append(SymbolAdapter.escapeChar(from.intValue()));
                continue;
            }
            b.append(SymbolAdapter.escapeChar(from.intValue()));
            b.append("-");
            b.append(SymbolAdapter.escapeChar(to.intValue()));
        }
        b.append("]");
        return b.toString();
    }

    private static ISet getConditions(IConstructor symbol) {
        return (ISet)symbol.get("conditions");
    }

    private static String escapeChar(int from) {
        if (from == 32) {
            return "\\ ";
        }
        String strRep = VF.string(from).toString();
        return strRep.substring(1, strRep.length() - 1);
    }

    private static IInteger getRangeEnd(IValue range) {
        return (IInteger)((IConstructor)range).get("end");
    }

    private static IInteger getRangeBegin(IValue range) {
        return (IInteger)((IConstructor)range).get("begin");
    }

    public static IList getRanges(IConstructor symbol) {
        return (IList)symbol.get("ranges");
    }

    public static IList getSymbols(IConstructor symbol) {
        return (IList)symbol.get("symbols");
    }

    private static String toString(IList symbols, char sep, boolean withLayout) {
        StringBuilder b = new StringBuilder();
        if (symbols.length() > 0) {
            b.append(SymbolAdapter.toString((IConstructor)symbols.get(0), false));
            for (int i = 1; i < symbols.length(); ++i) {
                IConstructor sym = (IConstructor)symbols.get(i);
                if (!withLayout && SymbolAdapter.isLayouts(sym)) continue;
                b.append(sep);
                b.append(SymbolAdapter.toString(sym, withLayout));
            }
        }
        return b.toString();
    }

    public static boolean isCons(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Cons;
    }

    public static boolean isFunc(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Func;
    }

    public static boolean isAlias(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Alias;
    }

    public static boolean isADT(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Adt;
    }

    public static boolean isReifiedType(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Reified;
    }

    public static boolean isBag(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Bag;
    }

    public static boolean isList(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_List;
    }

    public static boolean isSet(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Set;
    }

    public static boolean isTuple(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Tuple;
    }

    public static boolean isRel(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Rel;
    }

    public static boolean isListRel(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Lrel;
    }

    public static boolean isMap(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Map;
    }

    public static boolean isDatetime(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Datetime;
    }

    public static boolean isLoc(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Loc;
    }

    public static boolean isNum(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Num;
    }

    public static boolean isVoid(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Void;
    }

    public static boolean isValue(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Value;
    }

    public static boolean isNode(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Node;
    }

    public static boolean isRat(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Rat;
    }

    public static boolean isBool(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Bool;
    }

    public static boolean isReal(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Real;
    }

    public static boolean isStr(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Str;
    }

    public static boolean isInt(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Int;
    }

    public static boolean isParameter(IConstructor symbol) {
        return symbol.getConstructorType() == RascalValueFactory.Symbol_Parameter;
    }

    public static boolean isIterStarSeps(IConstructor rhs) {
        return (rhs = SymbolAdapter.delabel(rhs)).getConstructorType() == RascalValueFactory.Symbol_IterStarSeps;
    }

    public static boolean isIterPlusSeps(IConstructor rhs) {
        return (rhs = SymbolAdapter.delabel(rhs)).getConstructorType() == RascalValueFactory.Symbol_IterSeps;
    }

    public static IList getSeparators(IConstructor rhs) {
        rhs = SymbolAdapter.delabel(rhs);
        return (IList)rhs.get("separators");
    }

    public static boolean isLex(IConstructor rhs) {
        return rhs.getConstructorType() == RascalValueFactory.Symbol_Lex;
    }

    public static boolean isKeyword(IConstructor rhs) {
        return rhs.getConstructorType() == RascalValueFactory.Symbol_Keywords;
    }

    public static boolean isEmpty(IConstructor rhs) {
        return rhs.getConstructorType() == RascalValueFactory.Symbol_Empty;
    }

    public static boolean isEqual(IConstructor l, IConstructor r) {
        if (l == r) {
            return true;
        }
        while (SymbolAdapter.isLabel(l)) {
            l = SymbolAdapter.getLabeledSymbol(l);
        }
        while (SymbolAdapter.isLabel(r)) {
            r = SymbolAdapter.getLabeledSymbol(r);
        }
        while (SymbolAdapter.isConditional(l)) {
            l = SymbolAdapter.getSymbol(l);
        }
        while (SymbolAdapter.isConditional(r)) {
            r = SymbolAdapter.getSymbol(r);
        }
        if (l == r) {
            return true;
        }
        if (SymbolAdapter.isLayouts(l) && SymbolAdapter.isLayouts(r)) {
            return true;
        }
        if ((SymbolAdapter.isSort(l) || SymbolAdapter.isLex(l) || SymbolAdapter.isKeyword(l) || SymbolAdapter.isLayouts(l)) && (SymbolAdapter.isLex(r) || SymbolAdapter.isSort(r) || SymbolAdapter.isKeyword(r) || SymbolAdapter.isLayouts(r))) {
            return SymbolAdapter.getName(l).equals(SymbolAdapter.getName(r));
        }
        if (SymbolAdapter.isParameterizedSort(l) && SymbolAdapter.isParameterizedSort(r)) {
            return SymbolAdapter.getName(l).equals(SymbolAdapter.getName(r)) && SymbolAdapter.isEqual(SymbolAdapter.getParameters(l), SymbolAdapter.getParameters(r));
        }
        if (SymbolAdapter.isParameterizedLex(l) && SymbolAdapter.isParameterizedLex(r)) {
            return SymbolAdapter.getName(l).equals(SymbolAdapter.getName(r)) && SymbolAdapter.isEqual(SymbolAdapter.getParameters(l), SymbolAdapter.getParameters(r));
        }
        if (SymbolAdapter.isParameter(l) && SymbolAdapter.isParameter(r)) {
            return SymbolAdapter.getName(l).equals(SymbolAdapter.getName(r));
        }
        if (SymbolAdapter.isIterPlusSeps(l) && SymbolAdapter.isIterPlusSeps(r) || SymbolAdapter.isIterStarSeps(l) && SymbolAdapter.isIterStarSeps(r)) {
            return SymbolAdapter.isEqual(SymbolAdapter.getSymbol(l), SymbolAdapter.getSymbol(r)) && SymbolAdapter.isEqual(SymbolAdapter.getSeparators(l), SymbolAdapter.getSeparators(r));
        }
        if (SymbolAdapter.isIterPlus(l) && SymbolAdapter.isIterPlus(r) || SymbolAdapter.isIterStar(l) && SymbolAdapter.isIterStar(r) || SymbolAdapter.isOpt(l) && SymbolAdapter.isOpt(r)) {
            return SymbolAdapter.isEqual(SymbolAdapter.getSymbol(l), SymbolAdapter.getSymbol(r));
        }
        if (SymbolAdapter.isEmpty(l) && SymbolAdapter.isEmpty(r)) {
            return true;
        }
        if (SymbolAdapter.isAlt(l) && SymbolAdapter.isAlt(r)) {
            return SymbolAdapter.isEqual(SymbolAdapter.getAlternatives(l), SymbolAdapter.getAlternatives(r));
        }
        if (SymbolAdapter.isSeq(l) && SymbolAdapter.isSeq(r)) {
            return SymbolAdapter.isEqual(SymbolAdapter.getSequence(l), SymbolAdapter.getSequence(r));
        }
        if (SymbolAdapter.isLiteral(l) && SymbolAdapter.isLiteral(r) || SymbolAdapter.isCILiteral(l) && SymbolAdapter.isCILiteral(r) || SymbolAdapter.isCharClass(l) && SymbolAdapter.isCharClass(r)) {
            return l.equals(r);
        }
        if (SymbolAdapter.isStartSort(l) && SymbolAdapter.isStartSort(r)) {
            return SymbolAdapter.isEqual(SymbolAdapter.getStart(l), SymbolAdapter.getStart(r));
        }
        return false;
    }

    public static IList getParameters(IConstructor l) {
        return (IList)l.get("parameters");
    }

    public static boolean isCharClass(IConstructor r) {
        return r.getConstructorType() == RascalValueFactory.Symbol_CharClass;
    }

    private static IList getSequence(IConstructor r) {
        return (IList)r.get("symbols");
    }

    public static boolean isEqual(ISet l, ISet r) {
        if (l.size() != r.size()) {
            return false;
        }
        for (IValue le : l) {
            IValue re;
            Iterator iterator = r.iterator();
            if (!iterator.hasNext() || SymbolAdapter.isEqual((IConstructor)le, (IConstructor)(re = (IValue)iterator.next()))) continue;
            return false;
        }
        return true;
    }

    public static ISet getAlternatives(IConstructor r) {
        return (ISet)r.get("alternatives");
    }

    public static boolean isAlt(IConstructor l) {
        return l.getConstructorType() == RascalValueFactory.Symbol_Alt;
    }

    public static boolean isSeq(IConstructor l) {
        return l.getConstructorType() == RascalValueFactory.Symbol_Seq;
    }

    public static boolean isEqual(IList l, IList r) {
        if (l.length() != r.length()) {
            return false;
        }
        for (int i = 0; i < l.length(); ++i) {
            if (SymbolAdapter.isEqual((IConstructor)l.get(i), (IConstructor)r.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int getListSkipDelta(IConstructor sym) {
        if (SymbolAdapter.isIterPlus(sym) || SymbolAdapter.isIterStar(sym)) {
            return 1;
        }
        if (SymbolAdapter.isIterPlusSeps(sym) || SymbolAdapter.isIterStarSeps(sym)) {
            return SymbolAdapter.getSeparators(sym).length() + 1;
        }
        assert (false);
        return 1;
    }

    public static IConstructor starToPlus(IConstructor sym) {
        assert (SymbolAdapter.isStarList(sym) && !SymbolAdapter.isLabel(sym) && !SymbolAdapter.isConditional(sym));
        if (SymbolAdapter.isIterStar(sym)) {
            return VF.constructor(RascalValueFactory.Symbol_Iter, SymbolAdapter.getSymbol(sym));
        }
        if (SymbolAdapter.isIterStarSeps(sym)) {
            return VF.constructor(RascalValueFactory.Symbol_IterSeps, SymbolAdapter.getSymbol(sym), SymbolAdapter.getSeparators(sym));
        }
        assert (false);
        return sym;
    }

    public static IConstructor charClass(int ch) {
        return VF.constructor(RascalValueFactory.Symbol_CharClass, VF.list(VF.constructor(RascalValueFactory.CharRange_Range, VF.integer(ch), VF.integer(ch))));
    }

    public static IConstructor unionCharClasses(IConstructor lhs, IConstructor rhs) {
        if (lhs == rhs || lhs.equals(rhs)) {
            return lhs;
        }
        return SymbolAdapter.charclass(SymbolAdapter.unionRanges(SymbolAdapter.getRanges(lhs), SymbolAdapter.getRanges(rhs)));
    }

    public static IConstructor charclass(IList ranges) {
        return VF.constructor(RascalValueFactory.Symbol_CharClass, ranges);
    }

    public static IConstructor complementCharClass(IConstructor cc) {
        IConstructor everything = SymbolAdapter.charclass(VF.list(SymbolAdapter.range(1, 0x10FFFF)));
        return SymbolAdapter.differencesCharClasses(everything, cc);
    }

    public static IConstructor differencesCharClasses(IConstructor lhs, IConstructor rhs) {
        if (lhs == rhs || lhs.equals(rhs)) {
            return VF.constructor(RascalValueFactory.Symbol_CharClass, VF.list(new IValue[0]));
        }
        return SymbolAdapter.charclass(SymbolAdapter.differenceRanges(SymbolAdapter.getRanges(lhs), SymbolAdapter.getRanges(rhs)));
    }

    private static IList newRange(int from, int to) {
        return from > to ? VF.list(new IValue[0]) : VF.list(SymbolAdapter.range(from, to));
    }

    private static IList differenceRanges(IList l, IList r) {
        if (l.isEmpty() || r.isEmpty()) {
            return l;
        }
        IConstructor lhead = (IConstructor)l.get(0);
        IList ltail = l.delete(0);
        IConstructor rhead = (IConstructor)r.get(0);
        IList rtail = r.delete(0);
        if (SymbolAdapter.rangeBegin(lhead) > SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.differenceRanges(l, rtail);
        }
        if (SymbolAdapter.rangeEnd(lhead) < SymbolAdapter.rangeBegin(rhead)) {
            return SymbolAdapter.differenceRanges(ltail, r).insert(lhead);
        }
        if (SymbolAdapter.rangeBegin(lhead) >= SymbolAdapter.rangeBegin(rhead) && SymbolAdapter.rangeEnd(lhead) <= SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.differenceRanges(ltail, r);
        }
        if (SymbolAdapter.rangeBegin(rhead) >= SymbolAdapter.rangeBegin(lhead) && SymbolAdapter.rangeEnd(rhead) <= SymbolAdapter.rangeEnd(lhead)) {
            return SymbolAdapter.newRange(SymbolAdapter.rangeBegin(lhead), SymbolAdapter.rangeBegin(rhead) - 1).concat(SymbolAdapter.differenceRanges(SymbolAdapter.newRange(SymbolAdapter.rangeEnd(rhead) + 1, SymbolAdapter.rangeEnd(lhead)).concat(ltail), rtail));
        }
        if (SymbolAdapter.rangeEnd(lhead) < SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.newRange(SymbolAdapter.rangeBegin(lhead), SymbolAdapter.rangeBegin(rhead) - 1).concat(SymbolAdapter.differenceRanges(ltail, r));
        }
        if (SymbolAdapter.rangeBegin(lhead) > SymbolAdapter.rangeBegin(rhead)) {
            return SymbolAdapter.differenceRanges(SymbolAdapter.newRange(SymbolAdapter.rangeEnd(rhead) + 1, SymbolAdapter.rangeEnd(lhead)).concat(ltail), rtail);
        }
        throw new IllegalArgumentException("did not expect to end up here! <l> - <r>");
    }

    public static IConstructor intersectCharClasses(IConstructor lhs, IConstructor rhs) {
        if (lhs == rhs || lhs.equals(rhs)) {
            return lhs;
        }
        return SymbolAdapter.charclass(SymbolAdapter.intersectRanges(SymbolAdapter.getRanges(lhs), SymbolAdapter.getRanges(rhs)));
    }

    private static IList intersectRanges(IList l, IList r) {
        if (l.isEmpty()) {
            return l;
        }
        if (r.isEmpty()) {
            return r;
        }
        IConstructor lhead = (IConstructor)l.get(0);
        IList ltail = l.delete(0);
        IConstructor rhead = (IConstructor)r.get(0);
        IList rtail = r.delete(0);
        if (SymbolAdapter.rangeBegin(lhead) > SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.intersectRanges(l, rtail);
        }
        if (SymbolAdapter.rangeEnd(lhead) < SymbolAdapter.rangeBegin(rhead)) {
            return SymbolAdapter.intersectRanges(ltail, r);
        }
        if (SymbolAdapter.rangeBegin(lhead) >= SymbolAdapter.rangeBegin(rhead) && SymbolAdapter.rangeEnd(lhead) <= SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.intersectRanges(ltail, r).insert(lhead);
        }
        if (SymbolAdapter.rangeBegin(rhead) >= SymbolAdapter.rangeBegin(lhead) && SymbolAdapter.rangeEnd(rhead) <= SymbolAdapter.rangeEnd(lhead)) {
            return SymbolAdapter.intersectRanges(l, rtail).insert(rhead);
        }
        if (SymbolAdapter.rangeEnd(lhead) < SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.intersectRanges(ltail, r).insert(SymbolAdapter.range(SymbolAdapter.rangeBegin(rhead), SymbolAdapter.rangeEnd(lhead)));
        }
        if (SymbolAdapter.rangeBegin(lhead) > SymbolAdapter.rangeBegin(rhead)) {
            return SymbolAdapter.intersectRanges(l, rtail).insert(SymbolAdapter.range(SymbolAdapter.rangeBegin(lhead), SymbolAdapter.rangeEnd(rhead)));
        }
        throw new IllegalArgumentException("did not expect to end up here! <l> - <r>");
    }

    public static IConstructor normalizeCharClassRanges(IConstructor cc) {
        IList ranges = SymbolAdapter.getRanges(cc);
        IList result = VF.list(new IValue[0]);
        for (IValue range : ranges) {
            result = SymbolAdapter.unionRanges(result, VF.list(range));
        }
        return SymbolAdapter.charclass(result);
    }

    private static IList unionRanges(IList l, IList r) {
        if (l.isEmpty()) {
            return r;
        }
        if (r.isEmpty()) {
            return l;
        }
        IConstructor lhead = (IConstructor)l.get(0);
        IList ltail = l.delete(0);
        IConstructor rhead = (IConstructor)r.get(0);
        IList rtail = r.delete(0);
        if (SymbolAdapter.rangeBegin(lhead) > SymbolAdapter.rangeEnd(rhead) + 1) {
            return SymbolAdapter.unionRanges(l, rtail).insert(rhead);
        }
        if (SymbolAdapter.rangeEnd(lhead) + 1 < SymbolAdapter.rangeBegin(rhead)) {
            return SymbolAdapter.unionRanges(ltail, r).insert(lhead);
        }
        if (SymbolAdapter.rangeBegin(lhead) >= SymbolAdapter.rangeBegin(rhead) && SymbolAdapter.rangeEnd(lhead) <= SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.unionRanges(ltail, r);
        }
        if (SymbolAdapter.rangeBegin(rhead) >= SymbolAdapter.rangeBegin(lhead) && SymbolAdapter.rangeEnd(rhead) <= SymbolAdapter.rangeEnd(lhead)) {
            return SymbolAdapter.unionRanges(l, rtail);
        }
        if (SymbolAdapter.rangeEnd(lhead) < SymbolAdapter.rangeEnd(rhead)) {
            return SymbolAdapter.unionRanges(ltail.insert(SymbolAdapter.range(SymbolAdapter.rangeBegin(lhead), SymbolAdapter.rangeEnd(rhead))), rtail);
        }
        if (SymbolAdapter.rangeBegin(lhead) > SymbolAdapter.rangeBegin(rhead)) {
            return SymbolAdapter.unionRanges(ltail, rtail.insert(SymbolAdapter.range(SymbolAdapter.rangeBegin(rhead), SymbolAdapter.rangeEnd(lhead))));
        }
        throw new IllegalArgumentException("did not expect to end up here! union(<l>,<r>)");
    }

    private static IConstructor range(int begin, int end) {
        return VF.constructor(RascalValueFactory.CharRange_Range, VF.integer(begin), VF.integer(end));
    }

    private static int rangeBegin(IConstructor range) {
        return ((IInteger)range.get(0)).intValue();
    }

    private static int rangeEnd(IConstructor range) {
        return ((IInteger)range.get(1)).intValue();
    }

    public static boolean isParametrizableType(IConstructor sort) {
        return SymbolAdapter.isADT(sort) || SymbolAdapter.isParameterizedSort(sort) || SymbolAdapter.isParameterizedLex(sort);
    }
}

