---
title: "module analysis::flow::ObjectFlow"
id: ObjectFlow
slug: /Library/analysis/flow/ObjectFlow
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Intermediate Language and Basic Algorithms for object flow analysis
#### Usage

```rascal
import analysis::flow::ObjectFlow;
```

#### Dependencies
```rascal
import List;
extend analysis::graphs::Graph;
```

#### Description


The object flow language from the Tonella and Potrich book 
"Reverse Engineering Object Oriented Code" is an intermediate
representation for object flow. We may translate for example
Java to this intermediate language and then analyze object flow
based on the simpler language.
  
The implementation in this file is intended to work with [Core-M3](../../..//Library/analysis/m3/Core.md#analysis-m3-Core-M3) models


## data FlowProgram {#analysis-flow-ObjectFlow-FlowProgram}

```rascal
data FlowProgram  
     = flowProgram(set[FlowDecl] decls, set[FlowStm] statements)
     ;
```

## data FlowDecl {#analysis-flow-ObjectFlow-FlowDecl}
Figure 2.1

```rascal
data FlowDecl  
     = attribute(loc id)
     | method(loc id, list[loc] formalParameters)
     | constructor(loc id, list[loc] formalParameters)
     ;
```

## data FlowStm {#analysis-flow-ObjectFlow-FlowStm}
Figure 2.1

```rascal
data FlowStm  
     = newAssign(loc target, loc class, loc ctor, list[loc] actualParameters)
     | assign(loc target, loc cast, loc source)
     | call(loc target, loc cast, loc receiver, loc method, list[loc] actualParameters)
     ;
```

## alias OFG {#analysis-flow-ObjectFlow-OFG}

```rascal
rel[loc from, loc to]
```

## function buildFlowGraph {#analysis-flow-ObjectFlow-buildFlowGraph}

Figure 2.2

```rascal
OFG buildFlowGraph(FlowProgram p)
```

## function propagate {#analysis-flow-ObjectFlow-propagate}

Section 2.4

```rascal
rel[loc,&T] propagate(OFG g, rel[loc,&T] gen, rel[loc,&T] kill, bool back)
```

