---
title: "module lang::javascript::saner::Syntax"
id: Syntax
slug: /Library/lang/javascript/saner/Syntax
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

A saner grammar for JavaScript

It assumes:
- semicolons are present
- there is no comma expression
#### Usage

```rascal
import lang::javascript::saner::Syntax;
```



## syntax Source {#lang-javascript-saner-Syntax-Source}

```rascal
start syntax Source 
  = source: Statement* statements
  ;
```

## syntax Statement {#lang-javascript-saner-Syntax-Statement}

```rascal
syntax Statement 
  = varDecl: VarDecl varDecl
  | empty: ";"
  | block: "{" Statement* statements "}" 
  | expression: Expression!function expression ";"
  
  // Block level things
  | function: Function function
  | ifThen: "if" "(" Expression cond ")" Statement body () !>> "else" 
  | ifThenElse: "if" "(" Expression cond ")" Statement body "else" Statement elseBody
  | doWhile: "do" Statement body "while" "(" Expression cond ")" ";"
  | whileDo: "while" "(" Expression cond ")" Statement body
  | forDo: "for" "(" {Expression ","}* inits ";" {Expression ","}* conds ";" {Expression ","}* ops ")" Statement body
  | forDoDeclarations: "for" "(" "var" {VariableDeclarationNoIn ","}+ decls ";" {Expression ","}* conds ";" {Expression ","}* ops ")" Statement body  
  | forIn: "for" "(" Expression var "in" Expression obj ")" Statement body
  | forInDeclaration: "for" "(" "var" Id varId "in" Expression obj ")" Statement body
  | with: "with" "(" Expression scope ")" Statement body

  // Non local control flow
  | returnExp: "return"  Expression result ";"
  | returnNoExp: "return" ";"
  | throwExp: "throw" Expression result ";"
  | throwNoExp: "throw" ";"
  | continueLabel: "continue" Id label ";"
  | continueNoLabel: "continue" ";"
  | breakLabel: "break" Id label ";"
  | breakNoLabel: "break" ";"
  | debugger: "debugger" ";"
  | labeled: Id label ":" Statement statement
 
  | switchCase: "switch" "(" Expression cond ")" "{" CaseClause* clauses "}"
  | tryCatch: "try" Statement body "catch" "(" Id varId ")" Statement catchBody
  | tryFinally: "try" Statement body "finally" Statement finallyBody
  | tryCatchFinally: "try" Statement body "catch" "(" Id varId ")" Statement catchBody "finally" Statement finallyBody
  ;
```

## syntax VariableDeclaration {#lang-javascript-saner-Syntax-VariableDeclaration}

```rascal
syntax VariableDeclaration 
  = init: Id id "=" Expression init
  | nonInit: Id id
  ;
```

## syntax VariableDeclarationNoIn {#lang-javascript-saner-Syntax-VariableDeclarationNoIn}

```rascal
syntax VariableDeclarationNoIn
  = init: Id id "=" Expression!inn init
  | nonInit: Id id
  ;
```

## syntax CaseClause {#lang-javascript-saner-Syntax-CaseClause}

```rascal
syntax CaseClause 
  = caseOf: "case" Expression guard ":" Statement* body
  | defaultCase: "default" ":" Statement* body
  ;
```

## syntax Function {#lang-javascript-saner-Syntax-Function}

```rascal
syntax Function
  = "function" Id name "(" {Id ","}* parameters ")" "{" Statement* statements "}"
  | "function" "(" {Id ","}* parameters ")" "{" Statement* statements "}"
  ;
```

## syntax Expression {#lang-javascript-saner-Syntax-Expression}

```rascal
syntax Expression
  = array: "[" {Expression ","}* elements  ","? "]"
  | objectDefinition:"{" {PropertyAssignment ","}* properties ","? "}"
  | this: "this"
  | var: Id name
  | literal: Literal literal
  | bracket \bracket: "(" Expression arg ")" 
  | function: Function function
  > property: Expression obj "." Id fieldId 
  | call: Expression func "(" { Expression ","}* params ")" 
  | member: Expression obj "[" Expression field "]" 
  > new: "new" Expression cons
  > postIncr: Expression arg "++"
  | postDec: Expression arg "--"
  > delete: "delete" Expression arg
  | typeof: "typeof" Expression arg
  | preIncr: "++" Expression arg
  | preDecr: "--" Expression arg
  | prefixPlus: "+" !>> [+=] Expression arg
  | prefixMin: "-" !>> [\-=] Expression arg
  | binNeg: "~" Expression arg
  | not: "!" !>> [=] Expression arg
  >
  left (
      mul: Expression lhs "*" !>> [*=] Expression rhs
    | div: Expression lhs "/" !>> [/=] Expression rhs
    | rem: Expression lhs "%" !>> [%=] Expression rhs
  )
  >
  left (
      add: Expression lhs "+" !>> [+=]  Expression rhs
    | sub: Expression lhs "-" !>> [\-=] Expression rhs
  )
  > // right???
  left (
      shl: Expression lhs "\<\<" Expression rhs
    | shr: Expression lhs "\>\>" !>> [\>] Expression rhs
    | shrr: Expression lhs "\>\>\>" Expression rhs
  )
  >
  non-assoc (
      lt: Expression lhs "\<" Expression rhs
    | leq: Expression lhs "\<=" Expression rhs
    | gt: Expression lhs "\>" Expression rhs
    | geq: Expression lhs "\>=" Expression rhs
    | instanceof: Expression lhs "instanceof" Expression rhs
    | inn: Expression lhs "in" Expression rhs
  )
  >
  right (
      eqq: Expression lhs "===" Expression rhs
    | neqq: Expression lhs "!==" Expression rhs
    | eq: Expression lhs "==" !>> [=] Expression rhs
    | neq: Expression lhs "!=" !>> [=] Expression rhs
  )
  > right binAnd: Expression lhs "&" !>> [&=] Expression rhs
  > right binXor: Expression lhs "^" !>> [=] Expression rhs
  > right binOr: Expression lhs "|" !>> [|=] Expression rhs
  > left and: Expression lhs "&&" Expression rhs
  > left or: Expression lhs "||" Expression rhs
  > cond: Expression!cond cond "?" Expression!cond then ":" Expression elseExp
  > right (
      assign: Expression lhs "=" !>> [=] Expression rhs
    | assignMul: Expression lhs "*=" Expression rhs
    | assignDiv: Expression lhs "/=" Expression rhs
    | assignRem: Expression lhs "%=" Expression rhs
    | assignAdd: Expression lhs "+=" Expression rhs
    | assignSub: Expression lhs "-=" Expression rhs
    | assignShl: Expression lhs "\<\<=" Expression rhs
    | assignShr: Expression lhs "\>\>=" Expression rhs
    | assignShrr: Expression lhs "\>\>\>=" Expression rhs
    | assignBinAnd: Expression lhs "&=" Expression rhs
    | assignBinXor: Expression lhs "^=" Expression rhs
    | assignBinOr: Expression lhs "|=" Expression rhs
  )
  ;
```

## syntax VarDecl {#lang-javascript-saner-Syntax-VarDecl}

```rascal
syntax VarDecl
  = "var" {VariableDeclaration ","}+ declarations ";"
  ;
```

## syntax PropertyName {#lang-javascript-saner-Syntax-PropertyName}

```rascal
syntax PropertyName
 = id: Id name
 | string: String key
 | numeric: Numeric numeric
 ;
```

## syntax PropertyAssignment {#lang-javascript-saner-Syntax-PropertyAssignment}

```rascal
syntax PropertyAssignment
  = property: PropertyName name ":" Expression value
  | get: "get" PropertyName name "(" ")" "{" Statement* body "}"
  | \set: "set" PropertyName name "(" Id x ")" "{" Statement* body "}"
  ;
```

## syntax Literal {#lang-javascript-saner-Syntax-Literal}

```rascal
syntax Literal
 = null: "null"
 | boolean: Boolean bool
 | numeric: Numeric num
 | string: String str
 | regexp: RegularExpression regexp
 ;
```

## syntax Boolean {#lang-javascript-saner-Syntax-Boolean}

```rascal
syntax Boolean
  = t: "true"
  | f: "false"
  ;
```

## syntax Numeric {#lang-javascript-saner-Syntax-Numeric}

```rascal
syntax Numeric
  = decimal: [a-zA-Z$_0-9] !<< Decimal decimal
  | hexadecimal: [a-zA-Z$_0-9] !<< HexInteger hexInt
  ;
```

## syntax Decimal {#lang-javascript-saner-Syntax-Decimal}

```rascal
lexical Decimal
  = DecimalInteger [.] [0-9]* ExponentPart?
  | [.] [0-9]+ ExponentPart?
  | DecimalInteger ExponentPart?
  ;
```

## syntax DecimalInteger {#lang-javascript-saner-Syntax-DecimalInteger}

```rascal
lexical DecimalInteger
  = [0]
  | [1-9][0-9]*
  !>> [0-9]
  ;
```

## syntax ExponentPart {#lang-javascript-saner-Syntax-ExponentPart}

```rascal
lexical ExponentPart
  = [eE] SignedInteger
  ;
```

## syntax SignedInteger {#lang-javascript-saner-Syntax-SignedInteger}

```rascal
lexical SignedInteger
  = [+\-]? [0-9]+ !>> [0-9]
  ;
```

## syntax HexInteger {#lang-javascript-saner-Syntax-HexInteger}

```rascal
lexical HexInteger
  = [0] [Xx] [0-9a-fA-F]+ !>> [a-zA-Z_]
  ;
```

## syntax String {#lang-javascript-saner-Syntax-String}

```rascal
lexical String
  = [\"] DoubleStringChar* [\"]
  | [\'] SingleStringChar* [\']
  ;
```

## syntax DoubleStringChar {#lang-javascript-saner-Syntax-DoubleStringChar}

```rascal
lexical DoubleStringChar
  = ![\"\\\n]
  | [\\] EscapeSequence
  ;
```

## syntax SingleStringChar {#lang-javascript-saner-Syntax-SingleStringChar}

```rascal
lexical SingleStringChar
  = ![\'\\\n]
  | [\\] EscapeSequence
  ;
```

## syntax EscapeSequence {#lang-javascript-saner-Syntax-EscapeSequence}

```rascal
lexical EscapeSequence
  = CharacterEscapeSequence
  | [0] !>> [0-9]
  | HexEscapeSequence
  | UnicodeEscapeSequence
  ;
```

## syntax CharacterEscapeSequence {#lang-javascript-saner-Syntax-CharacterEscapeSequence}

```rascal
lexical CharacterEscapeSequence
  = SingleEscapeCharacter
  | NonEscapeCharacter
  ;
```

## syntax SingleEscapeCharacter {#lang-javascript-saner-Syntax-SingleEscapeCharacter}

```rascal
lexical SingleEscapeCharacter
  = [\'\"\\bfnrtv]
  ;
```

## syntax NonEscapeCharacter {#lang-javascript-saner-Syntax-NonEscapeCharacter}

```rascal
lexical NonEscapeCharacter
  // SourceCharacter but not one of EscapeCharacter or LineTerminator
  = ![\n\'\"\\bfnrtv0-9xu]
  ;
```

## syntax EscapeCharacter {#lang-javascript-saner-Syntax-EscapeCharacter}

```rascal
lexical EscapeCharacter
  = SingleEscapeCharacter
  | [0-9]
  | [xu]
  ;
```

## syntax HexDigit {#lang-javascript-saner-Syntax-HexDigit}

```rascal
lexical HexDigit
  = [a-fA-F0-9]
  ;
```

## syntax HexEscapeSequence {#lang-javascript-saner-Syntax-HexEscapeSequence}

```rascal
lexical HexEscapeSequence
  = [x] HexDigit HexDigit
  ;
```

## syntax UnicodeEscapeSequence {#lang-javascript-saner-Syntax-UnicodeEscapeSequence}

```rascal
lexical UnicodeEscapeSequence
  = "u" HexDigit HexDigit HexDigit HexDigit
  ;
```

## syntax RegularExpression {#lang-javascript-saner-Syntax-RegularExpression}

```rascal
lexical RegularExpression
  = [/] RegularExpressionBody [/] RegularExpressionFlags
  ;
```

## syntax RegularExpressionBody {#lang-javascript-saner-Syntax-RegularExpressionBody}

```rascal
lexical RegularExpressionBody
  = RegularExpressionFirstChar RegularExpressionChar*
  ;
```

## syntax RegularExpressionFirstChar {#lang-javascript-saner-Syntax-RegularExpressionFirstChar}

```rascal
lexical RegularExpressionFirstChar
  = ![*/\[\n\\]
  | RegularExpressionBackslashSequence
  | RegularExpressionClass
  ;
```

## syntax RegularExpressionChar {#lang-javascript-saner-Syntax-RegularExpressionChar}

```rascal
lexical RegularExpressionChar
  = ![/\[\n\\]
  | RegularExpressionBackslashSequence
  | RegularExpressionClass
  ;
```

## syntax RegularExpressionBackslashSequence {#lang-javascript-saner-Syntax-RegularExpressionBackslashSequence}

```rascal
lexical RegularExpressionBackslashSequence
  = [\\] ![\n]
  ;
```

## syntax RegularExpressionClass {#lang-javascript-saner-Syntax-RegularExpressionClass}

```rascal
lexical RegularExpressionClass
  = [\[] RegularExpressionClassChar* [\]]
  ;
```

## syntax RegularExpressionClassChar {#lang-javascript-saner-Syntax-RegularExpressionClassChar}

```rascal
lexical RegularExpressionClassChar
  = ![\n\]\\]
  | RegularExpressionBackslashSequence
  ;
```

## syntax RegularExpressionFlags {#lang-javascript-saner-Syntax-RegularExpressionFlags}

```rascal
lexical RegularExpressionFlags
  = [a-zA-Z]* !>> [a-zA-Z]
  ;
```

## syntax Whitespace {#lang-javascript-saner-Syntax-Whitespace}

```rascal
lexical Whitespace
  = [\t-\n\r\ ]
  ;
```

## syntax Comment {#lang-javascript-saner-Syntax-Comment}

```rascal
lexical Comment
  = @category="comment" "/*" CommentChar* "*/"
  | @category="comment" "//" ![\n]*  $
  ;
```

## syntax CommentChar {#lang-javascript-saner-Syntax-CommentChar}

```rascal
lexical CommentChar
  = ![*]
  | [*] !>> [/]
  ;
```

## syntax LAYOUT {#lang-javascript-saner-Syntax-LAYOUT}

```rascal
lexical LAYOUT
  = Whitespace
  | Comment
  ;
```

## syntax LAYOUTLIST {#lang-javascript-saner-Syntax-LAYOUTLIST}

```rascal
layout LAYOUTLIST
  = LAYOUT*
  !>> [\t\ \n]
  !>> "/*"
  !>> "//" ;
```

## syntax Id {#lang-javascript-saner-Syntax-Id}

```rascal
lexical Id 
  = ([a-zA-Z$_0-9] !<< [$_a-zA-Z] [a-zA-Z$_0-9]* !>> [a-zA-Z$_0-9]) \ Reserved
  ;
```

## syntax Reserved {#lang-javascript-saner-Syntax-Reserved}

```rascal
keyword Reserved =
    "break" |
    "case" |
    "catch" |
    "continue" |
    "debugger" |
    "default" |
    "delete" |
    "do" |
    "else" |
    "finally" |
    "for" |
    "function" |
    "if" |
    "instanceof" |
    "in" |
    "new" |
    "return" |
    "switch" |
    "this" |
    "throw" |
    "try" |
    "typeof" |
    "var" |
    "void" |
    "while" |
    "with" |
    "abstract" |
    "boolean" |
    "byte" |
    "char" |
    "class" |
    "const" |
    "double" |
    "enum" |
    "export" |
    "extends" |
    "final" |
    "float" |
    "goto" |
    "implements" |
    "import" |
    "interface" |
    "int" |
    "long" |
    "native" |
    "package" |
    "private" |
    "protected" |
    "public" |
    "short" |
    "static" |
    "super" |
    "synchronized" |
    "throws" |
    "transient" |
    "volatile" |
    "null" |
    "true" |
    "false"
  ;
```

