---
title: "module lang::pico::HiFiDemo"
id: HiFiDemo
slug: /Library/lang/pico/HiFiDemo
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Demonstrates HiFi source-to-source transformations through concrete syntax rewrites and text edits.
#### Usage

```rascal
import lang::pico::HiFiDemo;
```

#### Dependencies
```rascal
import lang::pico::\syntax::Main;
import IO;
import ParseTree;
import analysis::diff::edits::HiFiTreeDiff;
import analysis::diff::edits::ExecuteTextEdits;
```


## function flipConditionals {#lang-pico-HiFiDemo-flipConditionals}

Blindly swaps the branches of all the conditionals in a program

```rascal
start[Program] flipConditionals(start[Program] program)
```


This rule is syntactically correct and has a clear semantics. The 
layout of the resulting if-then-else-fi statement is also clear.

## function main {#lang-pico-HiFiDemo-main}

```rascal
void main()
```

