---
title: "module lang::pico::format::Formatting"
id: Formatting
slug: /Library/lang/pico/format/Formatting
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Demonstrates ((Tree2Box)), ((Box2Text)) and ((HiFiLayoutDiff)) for constructing a declarative and HiFi Pico formatting pipeline
#### Usage

```rascal
import lang::pico::format::Formatting;
```

#### Dependencies
```rascal
extend lang::box::util::Tree2Box;
import ParseTree;
import analysis::diff::edits::ExecuteTextEdits;
import analysis::diff::edits::HiFiLayoutDiff;
import lang::box::\syntax::Box;
import lang::box::util::Box2Text;
import lang::pico::\syntax::Main;
```

#### Description


Using four generic or generated, "language parametric", building blocks we construct a Pico formatting pipeline:

* [Parse Tree](../../../..//Library/ParseTree.md) is used to _generate_ a parser for Pico.   
* [Tree2 Box](../../../..//Library/lang/box/util/Tree2Box.md) provides the extensible/overridable and declarative [To Box](../../../..//Library/lang/pico/format/Formatting.md#lang-pico-format-Formatting-toBox) function which maps language constructs to Box expressions. 
The [To Box](../../../..//Library/lang/pico/format/Formatting.md#lang-pico-format-Formatting-toBox) function combines generic language-parametric rules, as well as bespoke language specific rules..
* [Box2 Text](../../../..//Library/lang/box/util/Box2Text.md) is a _generic_ reusable algorithm for two-dimensional string layout.
* Finally, [Hi Fi Layout Diff](../../../..//Library/analysis/diff/edits/HiFiLayoutDiff.md) _generically_ extracts [Text Edit](../../../..//Library/analysis/diff/edits/TextEdits.md#analysis-diff-edits-TextEdits-TextEdit)s from two trees which are equal modulo whitespace and comments.

#### Benefits


* The formatting is style is programmed _declaratively_ by mapping language patterns to Box expressions.
* The pipeline never loses source code comments, and this requires no attention from the language engineer.

#### Pitfalls


* [Box2 Text](../../../..//Library/lang/box/util/Box2Text.md) must be _extended_ for the open recursive calls of [To Box](../../../..//Library/lang/pico/format/Formatting.md#lang-pico-format-Formatting-toBox) to reach the extensions in the current module. 
If you import [Box2 Text](../../../..//Library/lang/box/util/Box2Text.md) the extended [To Box](../../../..//Library/lang/pico/format/Formatting.md#lang-pico-format-Formatting-toBox) rules will only be found if they describe top-level tree nodes.


## function formatPicoFile {#lang-pico-format-Formatting-formatPicoFile}

In-place formatting of an entire Pico file

```rascal
void formatPicoFile(loc file)
```

## function formatPicoString {#lang-pico-format-Formatting-formatPicoString}

Format a string that contains an entire Pico program

```rascal
str formatPicoString(str file)
```

## function formatPicoTree {#lang-pico-format-Formatting-formatPicoTree}

Pico Format function for reuse in file, str or IDE-based formatting contexts

```rascal
list[TextEdit] formatPicoTree(start[Program] file)
```

## function toBox {#lang-pico-format-Formatting-toBox}

Format while

```rascal
Box toBox((Statement) `while <Expression e> do <{Statement ";"}* block> od`, FO opts = fo())
```

## function toBox {#lang-pico-format-Formatting-toBox}

Format if-then-else 

```rascal
Box toBox((Statement) `if <Expression e> then <{Statement ";"}* thenPart> else <{Statement ";"}* elsePart> fi`, FO opts = fo())
```

