---
title: "module lang::pico::\\syntax::Main"
id: Main
slug: /Library/lang/pico/syntax/Main
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

#### Usage

```rascal
import lang::pico::\syntax::Main;
```

#### Dependencies
```rascal
import ParseTree;
```


## syntax Program {#lang-pico-\syntax-Main-Program}

```rascal
start syntax Program 
  = program: "begin" Declarations decls {Statement  ";"}* body "end" ;
```

## syntax Declarations {#lang-pico-\syntax-Main-Declarations}

```rascal
syntax Declarations 
  = "declare" {IdType ","}* decls ";" ;
```

## syntax IdType {#lang-pico-\syntax-Main-IdType}

```rascal
syntax IdType = idtype: Id id ":" Type t;
```

## syntax Statement {#lang-pico-\syntax-Main-Statement}

```rascal
syntax Statement 
  = assign: Id var ":="  Expression val 
  | cond: "if" Expression cond "then" {Statement ";"}*  thenPart "else" {Statement ";"}* elsePart "fi"
  | cond: "if" Expression cond "then" {Statement ";"}*  thenPart "fi"
  | loop: "while" Expression cond "do" {Statement ";"}* body "od"
  ;
```

## syntax Type {#lang-pico-\syntax-Main-Type}

```rascal
syntax Type 
  = natural:"natural" 
  | string :"string" 
  | nil    :"nil-type"
  ;
```

## syntax Expression {#lang-pico-\syntax-Main-Expression}

```rascal
syntax Expression 
  = id: Id name
  | strcon: String string
  | natcon: Natural natcon
  | bracket "(" Expression e ")"
  > left concat: Expression lhs "||" Expression rhs
  > left ( add: Expression lhs "+" Expression rhs
         | min: Expression lhs "-" Expression rhs
         )
  ;
```

## syntax Id {#lang-pico-\syntax-Main-Id}

```rascal
lexical Id  = [a-z][a-z0-9]* !>> [a-z0-9];
```

## syntax Natural {#lang-pico-\syntax-Main-Natural}

```rascal
lexical Natural = [0-9]+ ;
```

## syntax String {#lang-pico-\syntax-Main-String}

```rascal
lexical String = "\"" ![\"]*  "\"";
```

## syntax Layout {#lang-pico-\syntax-Main-Layout}

```rascal
layout Layout = WhitespaceAndComment* !>> [\ \t\n\r%];
```

## syntax WhitespaceAndComment {#lang-pico-\syntax-Main-WhitespaceAndComment}

```rascal
lexical WhitespaceAndComment 
   = [\ \t\n\r]
   | @category="comment" "%" ![%]+ "%"
   | @category="comment" "%%" ![\n]* $
   ;
```

## function program {#lang-pico-\syntax-Main-program}

```rascal
start[Program] program(str s)

start[Program] program(str s, loc l)
```

