---
title: "module lang::sexp::SExp"
id: SExp
slug: /Library/lang/sexp/SExp
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

AST model for S-Expressions.
#### Usage

```rascal
import lang::sexp::SExp;
```

#### Dependencies
```rascal
import lang::sexp::\syntax::SExp;
import ParseTree;
```


## data SExp {#lang-sexp-SExp-SExp}

```rascal
data SExp  
     = string(String \str)
     | \list(list[SExp] elts)
     ;
```

## data String {#lang-sexp-SExp-String}

```rascal
data String  
     = simple(SimpleString simpleStr)
     | display(str display, SimpleString simpleStr)
     ;
```

## data SimpleString {#lang-sexp-SExp-SimpleString}

```rascal
data SimpleString  
     = raw(Raw raw)
     | token(str \value)
     | base64(list[str] chars)
     | hex(list[str] digits)
     | quoted(str \value)
     ;
```

## data Raw {#lang-sexp-SExp-Raw}

```rascal
data Raw  
     = raw(int size, str bytes)
     ;
```

## function parseSExp {#lang-sexp-SExp-parseSExp}

```rascal
SExp parseSExp(str src, loc l)
```

