---
title: "module lang::smtlib2::command::response::Syntax"
id: Syntax
slug: /Library/lang/smtlib2/command/response/Syntax
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Synopsis: Grammar of the SMTLIBv2 response
#### Usage

```rascal
import lang::smtlib2::command::response::Syntax;
```

#### Dependencies
```rascal
extend lang::std::Layout;
```


## syntax Response {#lang-smtlib2-command-response-Syntax-Response}

```rascal
start syntax Response
	= response: CheckSat sat
	| response: GetValue model
	| response: GetUnsatCore unsatCore
	;
```

## syntax CheckSat {#lang-smtlib2-command-response-Syntax-CheckSat}

```rascal
syntax CheckSat 
	= sat: "sat" 
	| unsat: "unsat" 
	| unknown: "unknown"
	;
```

## syntax GetUnsatCore {#lang-smtlib2-command-response-Syntax-GetUnsatCore}

```rascal
syntax GetUnsatCore = unsatCore: "(" Label* labels ")";
```

## syntax GetValue {#lang-smtlib2-command-response-Syntax-GetValue}

```rascal
syntax GetValue = foundValues:"(" Model* models ")";
```

## syntax Model {#lang-smtlib2-command-response-Syntax-Model}

```rascal
syntax Model = model:"(" Expr var Expr val ")";
```

## syntax Expr {#lang-smtlib2-command-response-Syntax-Expr}

```rascal
syntax Expr
	= customFunctionCall: "(" Expr functionName Expr* params ")"
	| lit: Literal lit
	| var: Id varName
	;
```

## syntax Literal {#lang-smtlib2-command-response-Syntax-Literal}

```rascal
syntax Literal
	= intVal:Int int
	| boolVal: Bool b
	;
```

## syntax Int {#lang-smtlib2-command-response-Syntax-Int}

```rascal
lexical Int = '-'? [0-9]+ !>> [0-9];
```

## syntax Bool {#lang-smtlib2-command-response-Syntax-Bool}

```rascal
lexical Bool = "true" | "false";
```

## syntax Keywords {#lang-smtlib2-command-response-Syntax-Keywords}

```rascal
keyword Keywords = "true" | "false";
```

## syntax Id {#lang-smtlib2-command-response-Syntax-Id}

```rascal
lexical Id = ([a-z A-Z 0-9 _.] !<< [a-z A-Z][a-z A-Z 0-9 _.]* !>> [a-z A-Z 0-9 _.]) \Keywords;
```

## syntax Label {#lang-smtlib2-command-response-Syntax-Label}

```rascal
lexical Label = [a-z A-Z 0-9 _.$%|:/,?#\[\]] !<< [a-z A-Z 0-9 _.$%|:/,?#\[\]]* !>> [a-z A-Z 0-9 _.$%|:/,?#\[\]];
```

