---
title: "module lang::std::ANSI"
id: ANSI
slug: /Library/lang/std/ANSI
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Documents a part of the ANSI standard for terminal control sequences
#### Usage

```rascal
import lang::std::ANSI;
```



## syntax ANSI {#lang-std-ANSI-ANSI}

```rascal
lexical ANSI = Token* tokens;
```

## syntax Token {#lang-std-ANSI-Token}

```rascal
lexical Token
	= ControlCode            control
	| SpecialControlSequence special
	| OperatingSystemCommand command
	| ![\a1b\a07-\a1B]+ !>> ![\a1b\a07-\a1B] normal
	;
```

## syntax ControlCode {#lang-std-ANSI-ControlCode}

```rascal
lexical ControlCode 
    = bell          : [\a07]
    | backspace     : [\a07]
    | tab           : [\a09]
    | lineFeed      : [\a0A]
    | formFeed      : [\a0C]
    | carriageReturn: [\a0D]
    | escape        : [\a1B]
    ;
```

## syntax ControlSequenceIntroducer {#lang-std-ANSI-ControlSequenceIntroducer}

```rascal
lexical ControlSequenceIntroducer = [\a1B] [\[];
```

## syntax SpecialControlSequence {#lang-std-ANSI-SpecialControlSequence}

```rascal
lexical SpecialControlSequence = controlSequence: ControlSequenceIntroducer csi CSISequence code;
```

## syntax CSISequence {#lang-std-ANSI-CSISequence}

```rascal
lexical CSISequence 
    = cursorUp                   :  Number n [A]
	| cursorDown                 :  Number n [B]
	| cursorForward              :  Number n [C]
	| cursorBack                 :  Number n [D]
	| cursorNextLine             :  Number n [E]
	| cursorPreviousLine         :  Number n [F]
	| cursorHorizontalAbsolute   :  Number n [G]
	| cursorPosition             :  Number n [;] Number m [H]
	| clearToEndOfScreen         :  Number n [0]? [J]
	| clearToBeginningOfScreen   :  Number n [1] [J]
	| clearEntireScreen          :  Number n [2] [J]
	| clearEntireScreenAndBuffer :  Number n [3] [J]
	| clearToEndOfLine           :  "0" [K]
	| clearToBeginningOfLine     :  "1" [K]
	| clearEntireLine            :  "2" [K]
	| scrollUp                   :  Number n [S] 
	| scrollDown                 :  Number n [T] 
	| horizontalVerticalPosition :  Number n [;] Number m [f]
	| selectGraphicsRendition    :  Rendition r [m]
	| hideCursor                 :  "?25l"
	| showCursor                 :  "?25h"
    ;
```

## syntax OperatingSystemCommand {#lang-std-ANSI-OperatingSystemCommand}

```rascal
lexical OperatingSystemCommand = OperatingSystemCommandIntroducer osc OperatingSystemSequence code;
```

## syntax OperatingSystemCommandIntroducer {#lang-std-ANSI-OperatingSystemCommandIntroducer}

```rascal
lexical OperatingSystemCommandIntroducer = [\a1B] [\]];
```

## syntax OperatingSystemSequence {#lang-std-ANSI-OperatingSystemSequence}

```rascal
lexical OperatingSystemSequence
	= anchor : "8;" AnchorParameter* ";" ![\a1b]+ href ControlSequenceIntroducer csi ![\a1b]+  ControlSequenceIntroducer "8;;" ControlSequenceIntroducer [\\\a07]
	;
```

## syntax AnchorParameter {#lang-std-ANSI-AnchorParameter}

```rascal
lexical AnchorParameter = "id" ":" ![;:]+ val;
```

## syntax Rendition {#lang-std-ANSI-Rendition}

```rascal
lexical Rendition
    = reset                         : "0"
	| bold                          : "1"
	| faint                         : "2"	
	| italic                        : "3"
	| underline                     : "4"
	| slowBlink                     : "5"
	| rapidBlink                    : "6"
	| reverse                       : "7"
	| conceal                       : "8"
	| crossedOut                    : "9"
	| primaryFont                   : "10"
	| alternativeFont               : "1" FontChoice
	| fraktur                       : "20"
	| doubleUnderline               : "21"
	| normalIntensity               : "22"
	| neitherItalicNorBlackletter   : "23"
	| notUnderlined                 : "24"
	| notBlinking                   : "25"	
	| proportionalSpacing           : "26"
	| notReversed                   : "27"
	| notConcealed                  : "28"
	| notCrossedOut                 : "29"
	| setForegroundColor            : "3" ColorChoice
	| setForegroundColorRGB         : "38" "5" [;] Number color 
    | setForegroundColorRGB         : "38" "2" [;] Number red [;] Number green [;] Number blue
	| setDefaultForegroundColor     : "39"
    | setBackgroundColor            : "4" ColorChoice
    | setBackgroundColorRGB         : "48" "5" [;] Number color 
    | setBackgroundColorRGB         : "48" "2" [;] Number red [;] Number green [;] Number blue
	| setDefaultBackgroundColor     : "49"
	| disableProportionalSpacing    : "50"
	| framed                        : "51"
	| encircled                     : "52"
	| overlined                     : "53"
	| neitherFramedNorEncircled     : "54"
	| notOverlined                  : "55"
	| setUnderlineColor             : "58" "5" [;] Number color
    | setUnderlineColor             : "58" "2" [;] Number red [;] Number green [;] Number blue
	| defaultUnderlineColor         : "59"
	| rightsideLine                 : "60"	
	| rightsideDoubleLine           : "61"	
	| leftsideLine                  : "62"
	| leftsideDoubleLine            : "63"
	| stressMarking                 : "64"
	| resetAllLines                 : "65"
	| superscript                   : "73"	
	| subscript                     : "74"	
	| neitherSubscriptNorSuperScript: "75"
	| setBrightForegroundColor      : "9" ColorChoice
	| setBrightBackgroundColor      : "10" ColorChoice
    ;
```

## syntax Number {#lang-std-ANSI-Number}

```rascal
lexical Number      = [0-9]+;
```

## syntax ColorChoice {#lang-std-ANSI-ColorChoice}

```rascal
lexical ColorChoice = [0-7];
```

## syntax FontChoice {#lang-std-ANSI-FontChoice}

```rascal
lexical FontChoice  = [0-9];
```

## function number {#lang-std-ANSI-number}

Convenience function to construct a list of digits

```rascal
Number number(int n)
```

## function colorChoice {#lang-std-ANSI-colorChoice}

```rascal
ColorChoice colorChoice(int n)
```

## function fontChoice {#lang-std-ANSI-fontChoice}

```rascal
FontChoice fontChoice(int n)
```

