@bootstrapParser
module lang::rascal::tests::concrete::Patterns3

import ParseTree;
import Type;
import lang::rascal::\syntax::Rascal;
import Set;

rel[Sym, Name] extractPatternTree1(Concrete concrete){  
  psList = {<sym, n> | /hole(\one(Sym sym, Name n)) := concrete };
  return psList;
}

test bool concrete1() =  Concrete CT := T ?  size(extractPatternTree1(CT)) == 1 : false;
test bool concrete2() =  Concrete CT := T ? extractPatternTree1(CT) == ThePsList : false;

rel[Sym, Name]  extractPatternTree2(Concrete concrete){  
  psList = {};
  visit(concrete){
    case hole(\one(Sym sym, Name n)):  psList += {<sym, n>};
  }
  return psList;
}

test bool concrete3() = Concrete CT := T ? size(extractPatternTree2(CT)) == 1 : false;
test bool concrete4() = Concrete CT := T ? extractPatternTree2(CT) == ThePsList : false;


// Parse tree of (Concrete) `<A a>`
public Tree T =
appl(
  prod(
    label(
      "typed",
      lex("Concrete")),
    [
      lit("("),
      label(
        "l1",
        layouts("LAYOUTLIST")),
      label(
        "symbol",
        sort("Sym")),
      label(
        "l2",
        layouts("LAYOUTLIST")),
      lit(")"),
      label(
        "l3",
        layouts("LAYOUTLIST")),
      lit("`"),
      label(
        "parts",
        \iter-star(lex("ConcretePart"))),
      lit("`")
    ],
    {}),
  [appl(
      prod(
        lit("("),
        [\char-class([range(40,40)])],
        {}),
      [char(40)]),appl(
      prod(
        layouts("LAYOUTLIST"),
        [conditional(
            \iter-star(lex("LAYOUT")),
            {
              \not-follow(\char-class([
                    range(9,13),
                    range(32,32),
                    range(133,133),
                    range(160,160),
                    range(5760,5760),
                    range(6158,6158),
                    range(8192,8202),
                    range(8232,8233),
                    range(8239,8239),
                    range(8287,8287),
                    range(12288,12288)
                  ])),
              \not-follow(lit("//")),
              \not-follow(lit("/*"))
            })],
        {}),
      [appl(
          regular(\iter-star(lex("LAYOUT"))),
          [])[
          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(122,0,<9,9>,<9,9>)
        ]])[
      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(122,0,<9,9>,<9,9>)
    ],appl(
      prod(
        label(
          "nonterminal",
          sort("Sym")),
        [conditional(
            label(
              "nonterminal",
              lex("Nonterminal")),
            {\not-follow(lit("["))})],
        {}),
      [appl(
          prod(
            lex("Nonterminal"),
            [conditional(
                seq([
                    conditional(
                      \char-class([range(65,90)]),
                      {\not-precede(\char-class([range(65,90)]))}),
                    conditional(
                      \iter-star(\char-class([
                            range(48,57),
                            range(65,90),
                            range(95,95),
                            range(97,122)
                          ])),
                      {\not-follow(\char-class([
                              range(48,57),
                              range(65,90),
                              range(95,95),
                              range(97,122)
                            ]))})
                  ]),
                {delete(keywords("RascalKeywords"))})],
            {}),
          [appl(
              regular(seq([
                    conditional(
                      \char-class([range(65,90)]),
                      {\not-precede(\char-class([range(65,90)]))}),
                    conditional(
                      \iter-star(\char-class([
                            range(48,57),
                            range(65,90),
                            range(95,95),
                            range(97,122)
                          ])),
                      {\not-follow(\char-class([
                              range(48,57),
                              range(65,90),
                              range(95,95),
                              range(97,122)
                            ]))})
                  ])),
              [char(65),appl(
                  regular(\iter-star(\char-class([
                          range(48,57),
                          range(65,90),
                          range(95,95),
                          range(97,122)
                        ]))),
                  [])[
                  @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(123,0,<9,10>,<9,10>)
                ]])[
              @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(122,1,<9,9>,<9,10>)
            ]])[
          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(122,1,<9,9>,<9,10>)
        ]])[
      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(122,1,<9,9>,<9,10>)
    ],appl(
      prod(
        layouts("LAYOUTLIST"),
        [conditional(
            \iter-star(lex("LAYOUT")),
            {
              \not-follow(\char-class([
                    range(9,13),
                    range(32,32),
                    range(133,133),
                    range(160,160),
                    range(5760,5760),
                    range(6158,6158),
                    range(8192,8202),
                    range(8232,8233),
                    range(8239,8239),
                    range(8287,8287),
                    range(12288,12288)
                  ])),
              \not-follow(lit("//")),
              \not-follow(lit("/*"))
            })],
        {}),
      [appl(
          regular(\iter-star(lex("LAYOUT"))),
          [])[
          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(123,0,<9,10>,<9,10>)
        ]])[
      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(123,0,<9,10>,<9,10>)
    ],appl(
      prod(
        lit(")"),
        [\char-class([range(41,41)])],
        {}),
      [char(41)]),appl(
      prod(
        layouts("LAYOUTLIST"),
        [conditional(
            \iter-star(lex("LAYOUT")),
            {
              \not-follow(\char-class([
                    range(9,13),
                    range(32,32),
                    range(133,133),
                    range(160,160),
                    range(5760,5760),
                    range(6158,6158),
                    range(8192,8202),
                    range(8232,8233),
                    range(8239,8239),
                    range(8287,8287),
                    range(12288,12288)
                  ])),
              \not-follow(lit("//")),
              \not-follow(lit("/*"))
            })],
        {}),
      [appl(
          regular(\iter-star(lex("LAYOUT"))),
          [appl(
              prod(
                lex("LAYOUT"),
                [\char-class([
                      range(9,13),
                      range(32,32),
                      range(133,133),
                      range(160,160),
                      range(5760,5760),
                      range(6158,6158),
                      range(8192,8202),
                      range(8232,8233),
                      range(8239,8239),
                      range(8287,8287),
                      range(12288,12288)
                    ])],
                {}),
              [char(32)])[
              @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(124,1,<9,11>,<9,12>)
            ]])[
          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(124,1,<9,11>,<9,12>)
        ]])[
      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(124,1,<9,11>,<9,12>)
    ],appl(
      prod(
        lit("`"),
        [\char-class([range(96,96)])],
        {}),
      [char(96)]),appl(
      regular(\iter-star(lex("ConcretePart"))),
      [appl(
          prod(
            label(
              "hole",
              lex("ConcretePart")),
            [label(
                "hole",
                sort("ConcreteHole"))],
            {Attr::\tag("category"("MetaVariable"))}),
          [appl(
              prod(
                label(
                  "one",
                  sort("ConcreteHole")),
                [
                  lit("\<"),
                  layouts("LAYOUTLIST"),
                  label(
                    "symbol",
                    sort("Sym")),
                  layouts("LAYOUTLIST"),
                  label(
                    "name",
                    lex("Name")),
                  layouts("LAYOUTLIST"),
                  lit("\>")
                ],
                {}),
              [appl(
                  prod(
                    lit("\<"),
                    [\char-class([range(60,60)])],
                    {}),
                  [char(60)]),appl(
                  prod(
                    layouts("LAYOUTLIST"),
                    [conditional(
                        \iter-star(lex("LAYOUT")),
                        {
                          \not-follow(\char-class([
                                range(9,13),
                                range(32,32),
                                range(133,133),
                                range(160,160),
                                range(5760,5760),
                                range(6158,6158),
                                range(8192,8202),
                                range(8232,8233),
                                range(8239,8239),
                                range(8287,8287),
                                range(12288,12288)
                              ])),
                          \not-follow(lit("//")),
                          \not-follow(lit("/*"))
                        })],
                    {}),
                  [appl(
                      regular(\iter-star(lex("LAYOUT"))),
                      [])[
                      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,0,<9,14>,<9,14>)
                    ]])[
                  @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,0,<9,14>,<9,14>)
                ],appl(
                  prod(
                    label(
                      "nonterminal",
                      sort("Sym")),
                    [conditional(
                        label(
                          "nonterminal",
                          lex("Nonterminal")),
                        {\not-follow(lit("["))})],
                    {}),
                  [appl(
                      prod(
                        lex("Nonterminal"),
                        [conditional(
                            seq([
                                conditional(
                                  \char-class([range(65,90)]),
                                  {\not-precede(\char-class([range(65,90)]))}),
                                conditional(
                                  \iter-star(\char-class([
                                        range(48,57),
                                        range(65,90),
                                        range(95,95),
                                        range(97,122)
                                      ])),
                                  {\not-follow(\char-class([
                                          range(48,57),
                                          range(65,90),
                                          range(95,95),
                                          range(97,122)
                                        ]))})
                              ]),
                            {delete(keywords("RascalKeywords"))})],
                        {}),
                      [appl(
                          regular(seq([
                                conditional(
                                  \char-class([range(65,90)]),
                                  {\not-precede(\char-class([range(65,90)]))}),
                                conditional(
                                  \iter-star(\char-class([
                                        range(48,57),
                                        range(65,90),
                                        range(95,95),
                                        range(97,122)
                                      ])),
                                  {\not-follow(\char-class([
                                          range(48,57),
                                          range(65,90),
                                          range(95,95),
                                          range(97,122)
                                        ]))})
                              ])),
                          [char(65),appl(
                              regular(\iter-star(\char-class([
                                      range(48,57),
                                      range(65,90),
                                      range(95,95),
                                      range(97,122)
                                    ]))),
                              [])[
                              @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(128,0,<9,15>,<9,15>)
                            ]])[
                          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,1,<9,14>,<9,15>)
                        ]])[
                      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,1,<9,14>,<9,15>)
                    ]])[
                  @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,1,<9,14>,<9,15>)
                ],appl(
                  prod(
                    layouts("LAYOUTLIST"),
                    [conditional(
                        \iter-star(lex("LAYOUT")),
                        {
                          \not-follow(\char-class([
                                range(9,13),
                                range(32,32),
                                range(133,133),
                                range(160,160),
                                range(5760,5760),
                                range(6158,6158),
                                range(8192,8202),
                                range(8232,8233),
                                range(8239,8239),
                                range(8287,8287),
                                range(12288,12288)
                              ])),
                          \not-follow(lit("//")),
                          \not-follow(lit("/*"))
                        })],
                    {}),
                  [appl(
                      regular(\iter-star(lex("LAYOUT"))),
                      [appl(
                          prod(
                            lex("LAYOUT"),
                            [\char-class([
                                  range(9,13),
                                  range(32,32),
                                  range(133,133),
                                  range(160,160),
                                  range(5760,5760),
                                  range(6158,6158),
                                  range(8192,8202),
                                  range(8232,8233),
                                  range(8239,8239),
                                  range(8287,8287),
                                  range(12288,12288)
                                ])],
                            {}),
                          [char(32)])[
                          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(128,1,<9,15>,<9,16>)
                        ]])[
                      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(128,1,<9,15>,<9,16>)
                    ]])[
                  @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(128,1,<9,15>,<9,16>)
                ],appl(
                  prod(
                    lex("Name"),
                    [conditional(
                        seq([
                            conditional(
                              \char-class([
                                  range(65,90),
                                  range(95,95),
                                  range(97,122)
                                ]),
                              {\not-precede(\char-class([
                                      range(65,90),
                                      range(95,95),
                                      range(97,122)
                                    ]))}),
                            conditional(
                              \iter-star(\char-class([
                                    range(48,57),
                                    range(65,90),
                                    range(95,95),
                                    range(97,122)
                                  ])),
                              {\not-follow(\char-class([
                                      range(48,57),
                                      range(65,90),
                                      range(95,95),
                                      range(97,122)
                                    ]))})
                          ]),
                        {delete(keywords("RascalKeywords"))})],
                    {}),
                  [appl(
                      regular(seq([
                            conditional(
                              \char-class([
                                  range(65,90),
                                  range(95,95),
                                  range(97,122)
                                ]),
                              {\not-precede(\char-class([
                                      range(65,90),
                                      range(95,95),
                                      range(97,122)
                                    ]))}),
                            conditional(
                              \iter-star(\char-class([
                                    range(48,57),
                                    range(65,90),
                                    range(95,95),
                                    range(97,122)
                                  ])),
                              {\not-follow(\char-class([
                                      range(48,57),
                                      range(65,90),
                                      range(95,95),
                                      range(97,122)
                                    ]))})
                          ])),
                      [char(97),appl(
                          regular(\iter-star(\char-class([
                                  range(48,57),
                                  range(65,90),
                                  range(95,95),
                                  range(97,122)
                                ]))),
                          [])[
                          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(130,0,<9,17>,<9,17>)
                        ]])[
                      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(129,1,<9,16>,<9,17>)
                    ]])[
                  @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(129,1,<9,16>,<9,17>)
                ],appl(
                  prod(
                    layouts("LAYOUTLIST"),
                    [conditional(
                        \iter-star(lex("LAYOUT")),
                        {
                          \not-follow(\char-class([
                                range(9,13),
                                range(32,32),
                                range(133,133),
                                range(160,160),
                                range(5760,5760),
                                range(6158,6158),
                                range(8192,8202),
                                range(8232,8233),
                                range(8239,8239),
                                range(8287,8287),
                                range(12288,12288)
                              ])),
                          \not-follow(lit("//")),
                          \not-follow(lit("/*"))
                        })],
                    {}),
                  [appl(
                      regular(\iter-star(lex("LAYOUT"))),
                      [])[
                      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(130,0,<9,17>,<9,17>)
                    ]])[
                  @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(130,0,<9,17>,<9,17>)
                ],appl(
                  prod(
                    lit("\>"),
                    [\char-class([range(62,62)])],
                    {}),
                  [char(62)])])[
              @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(126,5,<9,13>,<9,18>)
            ]])[
          @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(126,5,<9,13>,<9,18>)
        ]])[
      @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(126,5,<9,13>,<9,18>)
    ],appl(
      prod(
        lit("`"),
        [\char-class([range(96,96)])],
        {}),
      [char(96)])])[
  @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(121,11,<9,8>,<9,19>)
];

rel[Tree,Tree] ThePsList =
{<appl(
    prod(
      label(
        "nonterminal",
        sort("Sym")),
      [conditional(
          label(
            "nonterminal",
            lex("Nonterminal")),
          {\not-follow(lit("["))})],
      {}),
    [appl(
        prod(
          lex("Nonterminal"),
          [conditional(
              seq([
                  conditional(
                    \char-class([range(65,90)]),
                    {\not-precede(\char-class([range(65,90)]))}),
                  conditional(
                    \iter-star(\char-class([
                          range(48,57),
                          range(65,90),
                          range(95,95),
                          range(97,122)
                        ])),
                    {\not-follow(\char-class([
                            range(48,57),
                            range(65,90),
                            range(95,95),
                            range(97,122)
                          ]))})
                ]),
              {delete(keywords("RascalKeywords"))})],
          {}),
        [appl(
            regular(seq([
                  conditional(
                    \char-class([range(65,90)]),
                    {\not-precede(\char-class([range(65,90)]))}),
                  conditional(
                    \iter-star(\char-class([
                          range(48,57),
                          range(65,90),
                          range(95,95),
                          range(97,122)
                        ])),
                    {\not-follow(\char-class([
                            range(48,57),
                            range(65,90),
                            range(95,95),
                            range(97,122)
                          ]))})
                ])),
            [char(65),appl(
                regular(\iter-star(\char-class([
                        range(48,57),
                        range(65,90),
                        range(95,95),
                        range(97,122)
                      ]))),
                [])[
                @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(128,0,<9,15>,<9,15>)
              ]])[
            @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,1,<9,14>,<9,15>)
          ]])[
        @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,1,<9,14>,<9,15>)
      ]])[
    @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(127,1,<9,14>,<9,15>)
  ],appl(
    prod(
      lex("Name"),
      [conditional(
          seq([
              conditional(
                \char-class([
                    range(65,90),
                    range(95,95),
                    range(97,122)
                  ]),
                {\not-precede(\char-class([
                        range(65,90),
                        range(95,95),
                        range(97,122)
                      ]))}),
              conditional(
                \iter-star(\char-class([
                      range(48,57),
                      range(65,90),
                      range(95,95),
                      range(97,122)
                    ])),
                {\not-follow(\char-class([
                        range(48,57),
                        range(65,90),
                        range(95,95),
                        range(97,122)
                      ]))})
            ]),
          {delete(keywords("RascalKeywords"))})],
      {}),
    [appl(
        regular(seq([
              conditional(
                \char-class([
                    range(65,90),
                    range(95,95),
                    range(97,122)
                  ]),
                {\not-precede(\char-class([
                        range(65,90),
                        range(95,95),
                        range(97,122)
                      ]))}),
              conditional(
                \iter-star(\char-class([
                      range(48,57),
                      range(65,90),
                      range(95,95),
                      range(97,122)
                    ])),
                {\not-follow(\char-class([
                        range(48,57),
                        range(65,90),
                        range(95,95),
                        range(97,122)
                      ]))})
            ])),
        [char(97),appl(
            regular(\iter-star(\char-class([
                    range(48,57),
                    range(65,90),
                    range(95,95),
                    range(97,122)
                  ]))),
            [])[
            @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(130,0,<9,17>,<9,17>)
          ]])[
        @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(129,1,<9,16>,<9,17>)
      ]])[
    @\loc=|project://rascal/src/org/rascalmpl/library/experiments/Compiler/Examples/Tst2.rsc|(129,1,<9,16>,<9,17>)
  ]>};
