/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.impl.reference.List;
import io.usethesource.vallang.impl.reference.Tuple;
import io.usethesource.vallang.impl.reference.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class ListWriter
implements IListWriter {
    private Type eltType = TypeFactory.getInstance().voidType();
    private final java.util.List<IValue> listContent = new LinkedList<IValue>();
    private @MonotonicNonNull IList constructedList;
    private boolean unique = false;

    ListWriter() {
    }

    private ListWriter(boolean unique) {
        this();
        this.unique = unique;
    }

    @Override
    public IWriter<IList> unique() {
        return new ListWriter(true);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.listContent.iterator();
    }

    private void checkMutation() {
        if (this.constructedList != null) {
            throw new UnsupportedOperationException("Mutation of a finalized list is not supported.");
        }
    }

    private void put(int index, IValue elem) {
        if (this.unique && this.listContent.contains(elem)) {
            return;
        }
        this.eltType = this.eltType.lub(elem.getType());
        this.listContent.add(index, elem);
    }

    public void insert(IValue elem) throws FactTypeUseException {
        this.checkMutation();
        this.put(0, elem);
    }

    @Override
    public void insert(IValue[] elems, int start, int length) throws FactTypeUseException {
        this.checkMutation();
        this.checkBounds(elems, start, length);
        for (int i = start + length - 1; i >= start; --i) {
            this.updateType(elems[i]);
            this.put(0, elems[i]);
        }
    }

    @Override
    public IValue replaceAt(int index, IValue elem) throws FactTypeUseException, IndexOutOfBoundsException {
        this.checkMutation();
        this.updateType(elem);
        return this.listContent.set(index, elem);
    }

    @Override
    public void insert(IValue ... elems) throws FactTypeUseException {
        this.insert(elems, 0, elems.length);
    }

    @Override
    public void insertAt(int index, IValue[] elems, int start, int length) throws FactTypeUseException {
        this.checkMutation();
        this.checkBounds(elems, start, length);
        for (int i = start + length - 1; i >= start; --i) {
            this.eltType = this.eltType.lub(elems[i].getType());
            this.put(index, elems[i]);
        }
    }

    @Override
    public void insertAt(int index, IValue ... elems) throws FactTypeUseException {
        this.insertAt(index, elems, 0, 0);
    }

    public void append(IValue elem) throws FactTypeUseException {
        this.checkMutation();
        this.updateType(elem);
        this.put(this.listContent.size(), elem);
    }

    @Override
    public void append(IValue ... elems) throws FactTypeUseException {
        this.checkMutation();
        for (IValue elem : elems) {
            this.updateType(elem);
            this.put(this.listContent.size(), elem);
        }
    }

    @Override
    public void appendTuple(IValue ... fields) {
        this.append((IValue)new Tuple(fields));
    }

    @Override
    public void appendAll(Iterable<? extends IValue> collection) throws FactTypeUseException {
        this.checkMutation();
        for (IValue iValue : collection) {
            this.put(this.listContent.size(), iValue);
        }
    }

    private void updateType(IValue v) {
        this.eltType = this.eltType.lub(v.getType());
    }

    @Override
    public IList done() {
        if (this.constructedList == null) {
            this.constructedList = new List(this.eltType, this.listContent);
        }
        return this.constructedList;
    }

    private void checkBounds(IValue[] elems, int start, int length) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("start < 0");
        }
        if (start + length > elems.length) {
            throw new ArrayIndexOutOfBoundsException("(start + length) > elems.length");
        }
    }

    @Override
    public IValue get(int i) throws IndexOutOfBoundsException {
        return this.listContent.get(i);
    }

    @Override
    public int length() {
        return this.listContent.size();
    }

    @Override
    public void insertTuple(IValue ... fields) {
        this.insert((IValue)ValueFactory.getInstance().tuple(fields));
    }

    @Override
    public Supplier<IWriter<IList>> supplier() {
        return () -> ValueFactory.getInstance().listWriter();
    }
}

