/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io;

import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.UnsupportedTypeException;
import io.usethesource.vallang.io.AbstractTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLReader
extends AbstractTextReader {
    private static final DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private static final TypeFactory TF = TypeFactory.getInstance();

    @Override
    public IValue read(IValueFactory factory, TypeStore store, Type type, Reader stream) throws FactTypeUseException, IOException {
        try {
            Document doc = domFactory.newDocumentBuilder().parse(new InputSource(stream));
            return new Parser(factory, store).parse(doc.getDocumentElement(), type);
        }
        catch (SAXException se) {
            throw new IOException("Parsing of value failed because XML was invalid: " + se.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Parsing of value failed because XML configuration is wrong: " + pce.getMessage());
        }
        catch (DOMException de) {
            throw new IOException("Parsing of value failed because of a XML document failure: " + de.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new FactParseError("Expected a number, got something different", nfe);
        }
    }

    private static class Parser {
        private final IValueFactory vf;
        private final TypeStore ts;

        public Parser(IValueFactory vf, TypeStore ts) {
            this.vf = vf;
            this.ts = ts;
        }

        private IValue parse(@Nullable Node node, Type expected) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            if (expected.isAbstractData()) {
                Type sort = expected;
                String name = node.getNodeName();
                if (this.isListWrapper(name, sort)) {
                    return this.parseList(node, sort);
                }
                if (this.isSetWrapper(name, sort)) {
                    return this.parseSet(node, sort);
                }
                if (this.isRelationWrapper(name, sort)) {
                    return this.parseRelation(node, sort);
                }
                if (this.isMapWrapper(name, sort)) {
                    return this.parseMap(node, sort);
                }
                return this.parseTreeSort(node, sort);
            }
            if (expected.equivalent(TF.stringType())) {
                return this.parseString(node);
            }
            if (expected.equivalent(TF.integerType())) {
                return this.parseInt(node);
            }
            if (expected.equivalent(TF.realType())) {
                return this.parseDouble(node);
            }
            if (expected.equivalent(TF.rationalType())) {
                return this.parseRational(node);
            }
            if (expected.isExternalType()) {
                return this.parseString(node);
            }
            throw new UnsupportedTypeException("Outermost or nested tuples, lists, sets, relations or maps are not allowed.", expected);
        }

        private boolean isListWrapper(String name, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
            if (nodeTypes.size() > 0) {
                Type nodeType = nodeTypes.iterator().next();
                return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isSubtypeOf(TF.listType(TF.valueType()));
            }
            return false;
        }

        private boolean isSetWrapper(String name, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
            if (nodeTypes.size() > 0) {
                Type nodeType = nodeTypes.iterator().next();
                return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isSubtypeOf(TF.setType(TF.valueType()));
            }
            return false;
        }

        private boolean isRelationWrapper(String name, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
            if (nodeTypes.size() > 0) {
                Type nodeType = nodeTypes.iterator().next();
                return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isSubtypeOf(TF.setType(TF.valueType())) && nodeType.getFieldTypes().getFieldType(0).getElementType().isFixedWidth();
            }
            return false;
        }

        private boolean isMapWrapper(String name, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, name);
            if (nodeTypes.size() > 0) {
                Type nodeType = nodeTypes.iterator().next();
                return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isMap();
            }
            return false;
        }

        private IValue parseRational(Node node) {
            String contents = this.getSafeNodeValue(node).trim();
            String[] parts = contents.split("r");
            if (parts.length == 2) {
                return this.vf.rational(this.vf.integer(Integer.parseInt(parts[0])), this.vf.integer(Integer.parseInt(parts[0])));
            }
            throw new FactParseError(contents, 0);
        }

        private IValue parseDouble(Node node) {
            return this.vf.real(Double.parseDouble(this.getSafeNodeValue(node).trim()));
        }

        private IValue parseInt(Node node) {
            return this.vf.integer(Integer.parseInt(this.getSafeNodeValue(node).trim()));
        }

        private IValue parseString(Node node) {
            return this.vf.string(this.getSafeNodeValue(node));
        }

        private String getSafeNodeValue(Node node) {
            String value = node.getNodeValue();
            if (value == null) {
                throw new FactParseError("node contains null value", 0);
            }
            return value;
        }

        private IValue parseMap(Node node, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
            Type nodeType = nodeTypes.iterator().next();
            Type mapType = nodeType.getFieldType(0);
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            NodeList children = node.getChildNodes();
            IMapWriter writer = this.vf.mapWriter();
            int i = 0;
            while (i + 1 < children.getLength()) {
                IValue value;
                IValue key;
                IValue[] finalElements;
                IValue[] elements;
                Type tuple;
                if (keyType.isFixedWidth()) {
                    tuple = keyType;
                    elements = new IValue[tuple.getArity()];
                    for (int j = 0; j < tuple.getArity(); ++j) {
                        elements[i] = this.parse(children.item(i++), tuple.getFieldType(j));
                    }
                    finalElements = elements;
                    key = this.vf.tuple(finalElements);
                } else {
                    key = this.parse(children.item(i++), keyType);
                }
                if (valueType.isFixedWidth()) {
                    tuple = keyType;
                    elements = new IValue[tuple.getArity()];
                    for (int j = 0; j < tuple.getArity(); ++j) {
                        elements[i] = this.parse(children.item(i++), tuple.getFieldType(j));
                    }
                    finalElements = elements;
                    value = this.vf.tuple(finalElements);
                } else {
                    value = this.parse(children.item(i++), valueType);
                }
                writer.put(key, value);
            }
            return this.vf.constructor(nodeType, new IValue[]{writer.done()});
        }

        private IValue parseRelation(Node node, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
            Type nodeType = nodeTypes.iterator().next();
            Type relType = nodeType.getFieldType(0);
            Type fields = relType.getFieldTypes();
            NodeList children = node.getChildNodes();
            ISetWriter writer = this.vf.setWriter();
            int i = 0;
            while (i < children.getLength()) {
                IValue[] elements = new IValue[fields.getArity()];
                for (int j = 0; i < children.getLength() && j < fields.getArity(); ++j) {
                    elements[j] = this.parse(children.item(i++), fields.getFieldType(j));
                }
                @NonNull IValue[] finalElements = elements;
                writer.insert(this.vf.tuple(finalElements));
            }
            return this.vf.constructor(nodeType, new IValue[]{writer.done()});
        }

        private IValue parseSet(Node node, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
            Type nodeType = nodeTypes.iterator().next();
            Type setType = nodeType.getFieldType(0);
            Type elementType = setType.getElementType();
            NodeList children = node.getChildNodes();
            ISetWriter writer = this.vf.setWriter();
            if (!elementType.isFixedWidth()) {
                for (int i = 0; i < children.getLength(); ++i) {
                    writer.insert(this.parse(children.item(i), elementType));
                }
            } else {
                Type tuple = elementType;
                int i = 0;
                while (i < children.getLength()) {
                    IValue[] elements = new IValue[tuple.getArity()];
                    for (int j = 0; i < children.getLength() && j < tuple.getArity(); ++j) {
                        elements[j] = this.parse(children.item(i++), tuple.getFieldType(j));
                    }
                    @NonNull IValue[] finalElements = elements;
                    writer.insert(this.vf.tuple(finalElements));
                }
            }
            return this.vf.constructor(nodeType, new IValue[]{writer.done()});
        }

        private IValue parseList(Node node, Type expected) {
            Set<Type> nodeTypes = this.ts.lookupConstructor(expected, node.getNodeName());
            Type nodeType = nodeTypes.iterator().next();
            Type listType = nodeType.getFieldType(0);
            Type elementType = listType.getElementType();
            NodeList children = node.getChildNodes();
            IListWriter writer = this.vf.listWriter();
            if (!elementType.isFixedWidth()) {
                for (int i = 0; i < children.getLength(); ++i) {
                    writer.append(this.parse(children.item(i), elementType));
                }
            } else {
                Type tuple = elementType;
                int i = 0;
                while (i < children.getLength()) {
                    IValue[] elements = new IValue[tuple.getArity()];
                    for (int j = 0; i < children.getLength() && j < tuple.getArity(); ++j) {
                        elements[j] = this.parse(children.item(i++), tuple.getFieldType(j));
                    }
                    @NonNull IValue[] finalElements = elements;
                    writer.append(this.vf.tuple(finalElements));
                }
            }
            return this.vf.constructor(nodeType, new IValue[]{writer.done()});
        }

        private IValue parseTreeSort(Node node, Type expected) {
            Type nodeType = this.ts.lookupConstructor(expected, node.getNodeName()).iterator().next();
            Type childrenTypes = nodeType.getFieldTypes();
            NodeList children = node.getChildNodes();
            IValue[] values = new IValue[nodeType.getArity()];
            int sourceIndex = 0;
            int targetIndex = 0;
            while (sourceIndex < children.getLength() && targetIndex < nodeType.getArity()) {
                Type childType = childrenTypes.getFieldType(targetIndex);
                if (childType.isFixedWidth()) {
                    Type tuple = childType;
                    IValue[] elements = new IValue[tuple.getArity()];
                    for (int tupleIndex = 0; tupleIndex < tuple.getArity() && sourceIndex < children.getLength(); ++tupleIndex, ++sourceIndex) {
                        elements[tupleIndex] = this.parse(children.item(sourceIndex), tuple.getFieldType(tupleIndex));
                    }
                    @NonNull IValue[] finalElements = elements;
                    values[targetIndex++] = this.vf.tuple(finalElements);
                    continue;
                }
                values[targetIndex++] = this.parse(children.item(sourceIndex++), childType);
            }
            return this.vf.constructor(nodeType, values);
        }
    }
}

