/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class ByteBufferOutputStream
extends OutputStream {
    protected ByteBuffer target;
    protected boolean closed = false;

    public ByteBufferOutputStream(ByteBuffer target) {
        this.target = target;
    }

    public ByteBuffer getBuffer() {
        return this.target;
    }

    protected abstract ByteBuffer flush(ByteBuffer var1) throws IOException;

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.target.flip();
        if (this.target.hasRemaining()) {
            this.target = this.flush(this.target);
            if (!this.target.hasRemaining()) {
                throw new IOException("flush implementation didn't correctly provide a new buffer to write to: " + String.valueOf(this.target));
            }
        } else {
            this.target.clear();
        }
        assert (this.target.hasRemaining()) : "after a flush, we should have a buffer with some room. (it was: " + String.valueOf(this.target) + ")";
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.flush();
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (!this.target.hasRemaining()) {
            this.flush();
        }
        this.target.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int chunk;
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        for (int written = 0; written < len; written += chunk) {
            if (!this.target.hasRemaining()) {
                this.flush();
            }
            chunk = Math.min(this.target.remaining(), len - written);
            this.target.put(b, off + written, chunk);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(ByteBuffer buf) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int originalLimit = buf.limit();
        while (buf.hasRemaining()) {
            if (!this.target.hasRemaining()) {
                this.flush();
            }
            int chunk = Math.min(this.target.remaining(), buf.remaining());
            buf.limit(buf.position() + chunk);
            this.target.put(buf);
            buf.limit(originalLimit);
        }
    }
}

