/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.ShellCommand;

public abstract class Command
extends AbstractAST {
    public Command(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasDeclaration() {
        return false;
    }

    public org.rascalmpl.ast.Declaration getDeclaration() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasExpression() {
        return false;
    }

    public org.rascalmpl.ast.Expression getExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasImported() {
        return false;
    }

    public org.rascalmpl.ast.Import getImported() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasCommand() {
        return false;
    }

    public ShellCommand getCommand() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasStatement() {
        return false;
    }

    public org.rascalmpl.ast.Statement getStatement() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDeclaration() {
        return false;
    }

    public boolean isExpression() {
        return false;
    }

    public boolean isImport() {
        return false;
    }

    public boolean isShell() {
        return false;
    }

    public boolean isStatement() {
        return false;
    }

    public static class Statement
    extends Command {
        private final org.rascalmpl.ast.Statement statement;

        public Statement(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Statement statement) {
            super(src, node);
            this.statement = statement;
        }

        @Override
        public boolean isStatement() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommandStatement(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.statement.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Statement)) {
                return false;
            }
            Statement tmp = (Statement)o;
            return tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 487 + 59 * this.statement.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Statement.newInstance(this.getClass(), this.src, null, this.clone(this.statement));
        }
    }

    public static class Shell
    extends Command {
        private final ShellCommand command;

        public Shell(ISourceLocation src, IConstructor node, ShellCommand command) {
            super(src, node);
            this.command = command;
        }

        @Override
        public boolean isShell() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommandShell(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.command.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.command.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Shell)) {
                return false;
            }
            Shell tmp = (Shell)o;
            return tmp.command.equals(this.command);
        }

        @Override
        public int hashCode() {
            return 199 + 661 * this.command.hashCode();
        }

        @Override
        public ShellCommand getCommand() {
            return this.command;
        }

        @Override
        public boolean hasCommand() {
            return true;
        }

        @Override
        public Object clone() {
            return Shell.newInstance(this.getClass(), this.src, null, this.clone(this.command));
        }
    }

    public static class Import
    extends Command {
        private final org.rascalmpl.ast.Import imported;

        public Import(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Import imported) {
            super(src, node);
            this.imported = imported;
        }

        @Override
        public boolean isImport() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommandImport(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.imported.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.imported.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Import)) {
                return false;
            }
            Import tmp = (Import)o;
            return tmp.imported.equals(this.imported);
        }

        @Override
        public int hashCode() {
            return 827 + 941 * this.imported.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Import getImported() {
            return this.imported;
        }

        @Override
        public boolean hasImported() {
            return true;
        }

        @Override
        public Object clone() {
            return Import.newInstance(this.getClass(), this.src, null, this.clone(this.imported));
        }
    }

    public static class Expression
    extends Command {
        private final org.rascalmpl.ast.Expression expression;

        public Expression(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Expression expression) {
            super(src, node);
            this.expression = expression;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommandExpression(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.expression.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Expression)) {
                return false;
            }
            Expression tmp = (Expression)o;
            return tmp.expression.equals(this.expression);
        }

        @Override
        public int hashCode() {
            return 7 + 173 * this.expression.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return Expression.newInstance(this.getClass(), this.src, null, this.clone(this.expression));
        }
    }

    public static class Declaration
    extends Command {
        private final org.rascalmpl.ast.Declaration declaration;

        public Declaration(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Declaration declaration) {
            super(src, node);
            this.declaration = declaration;
        }

        @Override
        public boolean isDeclaration() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommandDeclaration(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.declaration.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.declaration.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Declaration)) {
                return false;
            }
            Declaration tmp = (Declaration)o;
            return tmp.declaration.equals(this.declaration);
        }

        @Override
        public int hashCode() {
            return 857 + 509 * this.declaration.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Declaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public boolean hasDeclaration() {
            return true;
        }

        @Override
        public Object clone() {
            return Declaration.newInstance(this.getClass(), this.src, null, this.clone(this.declaration));
        }
    }
}

