/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Name;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.RedeclaredVariable;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ConcreteListVariablePattern
extends AbstractMatchingResult
implements IVarPattern {
    private String name;
    private NonTerminalType declaredType;
    private boolean anonymous = false;
    private boolean debug = false;
    private boolean iDeclaredItMyself;

    public ConcreteListVariablePattern(IEvaluatorContext ctx, AbstractAST x, Type type, Name name) {
        super(ctx, x);
        this.name = Names.name(name);
        this.declaredType = (NonTerminalType)type;
        this.anonymous = Names.name(name).equals("_");
        this.iDeclaredItMyself = false;
    }

    public ConcreteListVariablePattern(IEvaluatorContext ctx, AbstractAST x, Type type, String name) {
        super(ctx, x);
        this.name = name;
        this.declaredType = (NonTerminalType)type;
        this.anonymous = name.equals("_");
        this.iDeclaredItMyself = false;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return this.declaredType;
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        res.addFirst(this);
        return res;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean next() {
        if (this.debug) {
            System.err.println("AbstractConcreteSyntaxListVariable.next");
        }
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        this.hasNext = false;
        if (this.debug) {
            System.err.println("Subject: " + this.subject + " name: " + this.name + " getType: ");
            System.err.println("AbstractConcreteSyntaxListVariable.next: " + this.subject + "(type=" + this.subject.getStaticType() + ") with " + this.declaredType + " " + this.name);
        }
        if (!(this.anonymous || this.iDeclaredItMyself || this.ctx.getCurrentEnvt().declareVariable((Type)this.declaredType, this.name))) {
            throw new RedeclaredVariable(this.name, this.ctx.getCurrentAST());
        }
        this.iDeclaredItMyself = true;
        if (this.subject.getStaticType().isSubtypeOf(RascalValueFactory.Args)) {
            IConstructor sym;
            if (((IList)this.subject.getValue()).isEmpty() && (SymbolAdapter.isIterPlus(sym = this.declaredType.getSymbol()) || SymbolAdapter.isIterPlusSeps(sym))) {
                return false;
            }
            if (!this.anonymous) {
                this.ctx.getCurrentEnvt().storeVariable(this.name, ResultFactory.makeResult(this.declaredType, this.wrapWithListProd((IValue)this.subject.getValue()), this.ctx));
            }
            if (this.debug) {
                System.err.println("matches");
            }
            return true;
        }
        ITree subjectTree = (ITree)this.subject.getValue();
        if (TreeAdapter.isList(subjectTree)) {
            IConstructor sym;
            if (TreeAdapter.getArgs(subjectTree).isEmpty() && (SymbolAdapter.isIterPlus(sym = this.declaredType.getSymbol()) || SymbolAdapter.isIterPlusSeps(sym))) {
                return false;
            }
            IConstructor subjectListType = TreeAdapter.getType(subjectTree);
            IConstructor declaredListType = this.declaredType.getSymbol();
            if ((SymbolAdapter.isStarList(declaredListType) && SymbolAdapter.isAnyList(subjectListType) || SymbolAdapter.isPlusList(declaredListType) && SymbolAdapter.isPlusList(subjectListType)) && SymbolAdapter.isSepList(declaredListType) == SymbolAdapter.isSepList(subjectListType) && SymbolAdapter.getSymbol(subjectListType).equals(SymbolAdapter.getSymbol(declaredListType))) {
                this.ctx.getCurrentEnvt().storeVariable(this.name, ResultFactory.makeResult(this.declaredType, this.subject.getValue(), this.ctx));
                return true;
            }
            return false;
        }
        return false;
    }

    private IValue wrapWithListProd(IValue subject) {
        ITree arg;
        IList args = (IList)subject;
        IConstructor prod = this.ctx.getValueFactory().constructor(RascalValueFactory.Production_Regular, this.declaredType.getSymbol());
        if (args.length() == 1 && TreeAdapter.isList(arg = (ITree)args.get(0)) && TreeAdapter.getProduction(arg).equals(prod)) {
            return arg;
        }
        return this.ctx.getValueFactory().constructor(RascalValueFactory.Tree_Appl, prod, subject);
    }

    public String toString() {
        return this.declaredType + " " + this.name + ":=" + this.subject;
    }

    @Override
    public boolean isVarIntroducing() {
        return this.iDeclaredItMyself;
    }

    public boolean isPlusList() {
        IConstructor sym = this.declaredType.getSymbol();
        return SymbolAdapter.isIterPlus(sym) || SymbolAdapter.isIterPlusSeps(sym);
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public Type getType() {
        return this.declaredType;
    }
}

