/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.json.internal;

import com.google.gson.stream.JsonWriter;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.io.IOException;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.maybe.UtilMaybe;

public class JsonValueWriter {
    private ThreadLocal<SimpleDateFormat> format;
    private boolean datesAsInts = true;
    private boolean unpackedLocations = false;
    private boolean dropOrigins = true;
    private IFunction formatters;
    private boolean explicitConstructorNames = false;
    private boolean explicitDataTypes;
    private RascalNumber wrapper = new RascalNumber();

    public JsonValueWriter() {
        this.setCalendarFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public JsonValueWriter setCalendarFormat(final @Nullable String format) {
        if (format != null) {
            this.format = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(format);
                }
            };
        }
        return this;
    }

    public JsonValueWriter setDatesAsInt(boolean setting) {
        this.datesAsInts = setting;
        return this;
    }

    public JsonValueWriter setUnpackedLocations(boolean setting) {
        this.unpackedLocations = setting;
        return this;
    }

    public JsonValueWriter setDropOrigins(boolean setting) {
        this.dropOrigins = setting;
        return this;
    }

    public JsonValueWriter setFormatters(@Nullable IFunction formatters) {
        if (formatters != null && formatters.getType().getFieldType(0).isTop()) {
            formatters = null;
        }
        this.formatters = formatters;
        return this;
    }

    public JsonValueWriter setExplicitConstructorNames(boolean setting) {
        this.explicitConstructorNames = setting;
        return this;
    }

    public JsonValueWriter setExplicitDataTypes(boolean setting) {
        this.explicitDataTypes = setting;
        return this;
    }

    public void write(final JsonWriter out, IValue value) throws IOException {
        value.accept(new IValueVisitor<Void, IOException>(){

            @Override
            public Void visitString(IString o) throws IOException {
                out.value(o.getValue());
                return null;
            }

            @Override
            public Void visitReal(IReal o) throws IOException {
                JsonValueWriter.this.wrapper.wrapped = o;
                out.value(JsonValueWriter.this.wrapper);
                return null;
            }

            @Override
            public Void visitRational(IRational o) throws IOException {
                out.beginArray();
                o.numerator().accept(this);
                o.denominator().accept(this);
                out.endArray();
                return null;
            }

            @Override
            public Void visitList(IList o) throws IOException {
                out.beginArray();
                for (IValue v : o) {
                    v.accept(this);
                }
                out.endArray();
                return null;
            }

            @Override
            public Void visitSet(ISet o) throws IOException {
                out.beginArray();
                for (IValue v : o) {
                    v.accept(this);
                }
                out.endArray();
                return null;
            }

            @Override
            public Void visitSourceLocation(ISourceLocation o) throws IOException {
                if (JsonValueWriter.this.unpackedLocations) {
                    out.beginObject();
                    out.name("scheme");
                    out.value(o.getScheme());
                    out.name("authority");
                    out.value(o.getAuthority());
                    out.name("path");
                    out.value(o.getPath());
                    if (!o.getFragment().isEmpty()) {
                        out.name("fragment");
                        out.value(o.getFragment());
                    }
                    if (!o.getQuery().isEmpty()) {
                        out.name("query");
                        out.value(o.getQuery());
                    }
                    if (o.hasOffsetLength()) {
                        out.name("offset");
                        out.value(o.getOffset());
                        out.name("length");
                        out.value(o.getLength());
                    }
                    if (o.hasLineColumn()) {
                        out.name("begin");
                        out.beginArray();
                        out.value(o.getBeginLine());
                        out.value(o.getBeginColumn());
                        out.endArray();
                        out.name("end");
                        out.beginArray();
                        out.value(o.getEndLine());
                        out.value(o.getEndColumn());
                        out.endArray();
                    }
                    out.endObject();
                } else if (!o.hasOffsetLength()) {
                    if ("file".equals(o.getScheme())) {
                        out.value(o.getPath());
                    } else {
                        out.value(o.getURI().toASCIIString());
                    }
                } else {
                    out.value(o.toString());
                }
                return null;
            }

            @Override
            public Void visitTuple(ITuple o) throws IOException {
                out.beginArray();
                for (IValue v : o) {
                    v.accept(this);
                }
                out.endArray();
                return null;
            }

            @Override
            public Void visitNode(INode o) throws IOException {
                out.beginObject();
                out.name("_name");
                out.value(o.getName());
                int i = 0;
                for (IValue arg : o) {
                    out.name("__arg" + i++);
                    arg.accept(this);
                }
                Map<String, IValue> parameters = o.asWithKeywordParameters().getParameters();
                String originKey = parameters.containsKey("rascal-src") ? "rascal-src" : "src";
                for (Map.Entry<String, IValue> e : parameters.entrySet()) {
                    if (JsonValueWriter.this.dropOrigins && e.getKey().equals(originKey)) continue;
                    out.name(e.getKey());
                    e.getValue().accept(this);
                }
                out.endObject();
                return null;
            }

            @Override
            public Void visitConstructor(IConstructor o) throws IOException {
                if (UtilMaybe.isMaybe(o.getType())) {
                    if (UtilMaybe.isNothing(o)) {
                        out.nullValue();
                    } else {
                        o.get(0).accept(this);
                    }
                }
                if (JsonValueWriter.this.formatters != null) {
                    try {
                        Object formatted = JsonValueWriter.this.formatters.call(o);
                        if (formatted != null) {
                            this.visitString((IString)formatted);
                            return null;
                        }
                    }
                    catch (Throw formatted) {
                        // empty catch block
                    }
                }
                if (!(JsonValueWriter.this.explicitConstructorNames || JsonValueWriter.this.explicitDataTypes || o.getConstructorType().getArity() != 0 || o.asWithKeywordParameters().hasParameters())) {
                    out.value(o.getName());
                    return null;
                }
                out.beginObject();
                if (JsonValueWriter.this.explicitConstructorNames || JsonValueWriter.this.explicitDataTypes) {
                    out.name("_constructor");
                    out.value(o.getName());
                }
                if (JsonValueWriter.this.explicitDataTypes) {
                    out.name("_type");
                    out.value(o.getType().getName());
                }
                int i = 0;
                for (IValue iValue : o) {
                    out.name(o.getConstructorType().getFieldName(i));
                    iValue.accept(this);
                    ++i;
                }
                for (Map.Entry entry : o.asWithKeywordParameters().getParameters().entrySet()) {
                    out.name((String)entry.getKey());
                    ((IValue)entry.getValue()).accept(this);
                }
                out.endObject();
                return null;
            }

            @Override
            public Void visitInteger(IInteger o) throws IOException {
                JsonValueWriter.this.wrapper.wrapped = o;
                out.value(JsonValueWriter.this.wrapper);
                return null;
            }

            @Override
            public Void visitMap(IMap o) throws IOException {
                if (o.isEmpty()) {
                    out.beginObject();
                    out.endObject();
                } else if (o.getKeyType().isString()) {
                    out.beginObject();
                    for (IValue key : o) {
                        out.name(((IString)key).getValue());
                        o.get(key).accept(this);
                    }
                    out.endObject();
                } else if (o.getKeyType().isSourceLocation() && !JsonValueWriter.this.unpackedLocations) {
                    out.beginObject();
                    for (IValue key : o) {
                        ISourceLocation l = (ISourceLocation)key;
                        if (!l.hasOffsetLength()) {
                            if ("file".equals(l.getScheme())) {
                                out.name(l.getPath());
                            } else {
                                out.name(l.getURI().toASCIIString());
                            }
                        } else {
                            out.name(l.toString());
                        }
                        o.get(key).accept(this);
                    }
                    out.endObject();
                } else {
                    out.beginArray();
                    for (IValue key : o) {
                        out.beginArray();
                        key.accept(this);
                        o.get(key).accept(this);
                        out.endArray();
                    }
                    out.endArray();
                }
                return null;
            }

            @Override
            public Void visitBoolean(IBool boolValue) throws IOException {
                out.value(boolValue.getValue());
                return null;
            }

            @Override
            public Void visitExternal(IExternalValue externalValue) throws IOException {
                throw new IOException("External values are not supported by JSon serialisation yet");
            }

            @Override
            public Void visitDateTime(IDateTime o) throws IOException {
                if (JsonValueWriter.this.datesAsInts) {
                    out.value(o.getInstant());
                } else {
                    try {
                        SimpleDateFormat sd = JsonValueWriter.this.format.get();
                        Calendar cal = Prelude.getCalendarForDateTime(o);
                        sd.setCalendar(cal);
                        out.value(sd.format(cal.getTime()));
                    }
                    catch (IllegalArgumentException iae) {
                        throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print datetime " + o + " using format string: " + JsonValueWriter.this.format.get());
                    }
                }
                return null;
            }
        });
    }

    private static class RascalNumber
    extends Number {
        private static final long serialVersionUID = -2204435793489295963L;
        public INumber wrapped;

        private RascalNumber() {
        }

        @Override
        public int intValue() {
            return this.wrapped.toInteger().intValue();
        }

        @Override
        public long longValue() {
            return this.wrapped.toInteger().longValue();
        }

        @Override
        public float floatValue() {
            return this.wrapped.toReal(20).floatValue();
        }

        @Override
        public double doubleValue() {
            return this.wrapped.toReal(20).doubleValue();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }
}

