/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.EpsilonNode;
import org.rascalmpl.parser.gtd.stack.AbstractMatchableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public final class EpsilonStackNode<P>
extends AbstractMatchableStackNode<P> {
    public static final EpsilonNode EPSILON_RESULT = new EpsilonNode();
    private final AbstractNode result;

    public EpsilonStackNode(int id, int dot) {
        super(id, dot);
        this.result = null;
    }

    public EpsilonStackNode(int id, int dot, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.result = null;
    }

    private EpsilonStackNode(EpsilonStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.result = null;
    }

    private EpsilonStackNode(EpsilonStackNode<P> original, int startLocation, AbstractNode result) {
        super(original, startLocation);
        this.result = result;
    }

    @Override
    public boolean isEmptyLeafNode() {
        return true;
    }

    @Override
    public AbstractNode match(int[] input, int location) {
        return EPSILON_RESULT;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new EpsilonStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P> getCleanCopyWithResult(int startLocation, AbstractNode result) {
        return new EpsilonStackNode<P>(this, startLocation, result);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public AbstractNode getResult() {
        return this.result;
    }

    @Override
    public String toShortString() {
        return "\u03b5";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.startLocation);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof EpsilonStackNode)) {
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

