/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class DoubleStack<E, F> {
    private static final int DEFAULT_SIZE = 8;
    private E[] firstData;
    private F[] secondData;
    private int size;

    public DoubleStack() {
        this.firstData = new Object[8];
        this.secondData = new Object[8];
        this.size = 0;
    }

    public DoubleStack(int initialSize) {
        this.firstData = new Object[initialSize];
        this.secondData = new Object[initialSize];
        this.size = 0;
    }

    public void enlarge() {
        E[] oldFirstData = this.firstData;
        this.firstData = new Object[this.size << 1];
        System.arraycopy(oldFirstData, 0, this.firstData, 0, this.size);
        F[] oldSecondData = this.secondData;
        this.secondData = new Object[this.size << 1];
        System.arraycopy(oldSecondData, 0, this.secondData, 0, this.size);
    }

    public void push(E first, F second) {
        while (this.size >= this.firstData.length) {
            this.enlarge();
        }
        this.firstData[this.size] = first;
        this.secondData[this.size++] = second;
    }

    public E peekFirst() {
        return this.firstData[this.size - 1];
    }

    public F peekSecond() {
        return this.secondData[this.size - 1];
    }

    public E popFirst() {
        E first = this.firstData[--this.size];
        this.firstData[this.size] = null;
        this.secondData[this.size] = null;
        return first;
    }

    public F popSecond() {
        F second = this.secondData[--this.size];
        this.firstData[this.size] = null;
        this.secondData[this.size] = null;
        return second;
    }

    public void purge() {
        this.firstData[--this.size] = null;
    }

    public E dirtyPop() {
        return this.firstData[--this.size];
    }

    public void dirtyPurge() {
        --this.size;
    }

    public E getFirst(int index) {
        return this.firstData[index];
    }

    public F getSecond(int index) {
        return this.secondData[index];
    }

    public int findFirst(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.firstData[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public int findSecond(F object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.secondData[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsFirst(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.firstData[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSecond(F object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.secondData[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public E findFirstWithFirst(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            E objectToCompareWith = this.firstData[i];
            if (!objectToCompareWith.equals(object)) continue;
            return objectToCompareWith;
        }
        return null;
    }

    public F findSecondWithFirst(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.firstData[i].equals(object)) continue;
            return this.secondData[i];
        }
        return null;
    }

    public E findFirstWithSecond(F object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.secondData[i].equals(object)) continue;
            return this.firstData[i];
        }
        return null;
    }

    public F findSecondWithSecond(F object) {
        for (int i = this.size - 1; i >= 0; --i) {
            F objectToCompareWith = this.secondData[i];
            if (!objectToCompareWith.equals(object)) continue;
            return objectToCompareWith;
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.firstData = new Object[this.firstData.length];
        this.secondData = new Object[this.secondData.length];
        this.size = 0;
    }

    public void dirtyClear() {
        this.size = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("stack[");
        for (int i = 0; i < this.size; ++i) {
            builder.append("\n    ");
            builder.append("<");
            builder.append(this.firstData[0]);
            builder.append(",");
            builder.append(this.secondData[1]);
            builder.append(">");
        }
        builder.append("]\n");
        return builder.toString();
    }
}

