/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.streams;

import java.io.IOException;
import java.io.Writer;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.repl.streams.NonClosingFilterWriter;

public class LimitedLineWriter
extends NonClosingFilterWriter {
    private final long limit;
    private int written;

    public LimitedLineWriter(Writer out, long limit) {
        super(out);
        this.limit = limit;
        this.written = 0;
    }

    @Override
    public void write(int c) throws IOException {
        if ((long)this.written == this.limit) {
            throw new LimitedResultWriter.IOLimitReachedException();
        }
        this.out.write(c);
        if (c == 10 || c == 13) {
            ++this.written;
            if ((long)this.written == this.limit) {
                this.out.write("...");
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if ((long)this.written == this.limit) {
            throw new LimitedResultWriter.IOLimitReachedException();
        }
        len = this.calculateNewLength(cbuf, off, len);
        this.out.write(cbuf, off, len);
        if ((long)this.written == this.limit) {
            this.out.write("...");
        }
    }

    private int calculateNewLength(char[] cbuf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (cbuf[i] != '\n' && cbuf[i] != '\r') continue;
            ++this.written;
            if ((long)this.written != this.limit) continue;
            return Math.min(i + 1 - off, len);
        }
        return len;
    }

    private int calculateNewLength(String str, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (str.charAt(i) != '\n' && str.charAt(i) != '\r') continue;
            ++this.written;
            if ((long)this.written != this.limit) continue;
            return Math.min(i + 1 - off, len);
        }
        return len;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if ((long)this.written == this.limit) {
            throw new LimitedResultWriter.IOLimitReachedException();
        }
        len = this.calculateNewLength(str, off, len);
        this.out.write(str, off, len);
        if ((long)this.written == this.limit) {
            this.out.write("...");
        }
    }
}

