/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.iterators;

import io.usethesource.capsule.Set;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import java.util.Iterator;
import java.util.Stack;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.iterators.MapKeyValueIterator;
import org.rascalmpl.values.iterators.TupleElementIterator;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class DescendantReader
implements Iterator<IValue> {
    Stack<Object> spine = new Stack();
    IValue nextValue;
    private Set.Transient<ITree> visitedAmbs = Set.Transient.of();
    private boolean debug = false;
    private boolean interpretTree;

    DescendantReader(IValue val, boolean interpretTree) {
        if (this.debug) {
            System.err.println("DescendantReader: " + val);
        }
        this.interpretTree = interpretTree;
        this.push(val);
    }

    private void findNext() {
        do {
            this.nextValue = null;
            if (this.spine.size() == 0) {
                return;
            }
            Object next = this.spine.peek();
            if (next instanceof Iterator) {
                Iterator iter = (Iterator)next;
                if (!iter.hasNext()) {
                    this.spine.pop();
                    continue;
                }
                this.push((IValue)iter.next());
                continue;
            }
            this.nextValue = (IValue)this.spine.pop();
        } while (this.nextValue == null);
    }

    @Override
    public boolean hasNext() {
        if (this.nextValue == null) {
            this.findNext();
        }
        return this.nextValue != null;
    }

    @Override
    public IValue next() {
        IValue next = this.nextValue;
        this.findNext();
        return next;
    }

    private void push(IValue v, Iterator<IValue> children) {
        this.spine.push(v);
        this.spine.push(children);
    }

    private void pushAmb(ITree amb) {
        if (!this.visitedAmbs.contains(amb)) {
            this.visitedAmbs.__insert(amb);
            this.spine.push(amb);
            for (IValue alt : TreeAdapter.getAlternatives(amb)) {
                this.push(alt);
            }
        }
    }

    private void push(IValue v) {
        Type type = v.getType();
        if (type.isNode() || type.isConstructor() || type.isAbstractData()) {
            if (type.isSubtypeOf(RascalValueFactory.Tree)) {
                ITree tree = (ITree)v;
                if (TreeAdapter.isAmb(tree)) {
                    this.pushAmb(tree);
                    return;
                }
                if (this.interpretTree) {
                    this.pushConcreteSyntaxNode(tree);
                    return;
                }
            }
            INode node = (INode)v;
            this.push(v, node.getChildren().iterator());
            if (node.mayHaveKeywordParameters()) {
                this.pushKeywordParameters(node.asWithKeywordParameters());
            }
        } else if (type.isList()) {
            this.push(v, ((IList)v).iterator());
        } else if (type.isSet()) {
            this.push(v, ((ISet)v).iterator());
        } else if (type.isMap()) {
            this.push(v, new MapKeyValueIterator((IMap)v));
        } else if (type.isTuple()) {
            this.push(v, new TupleElementIterator((ITuple)v));
        } else {
            this.spine.push(v);
        }
    }

    private void pushKeywordParameters(IWithKeywordParameters<? extends INode> node) {
        for (String name : node.getParameterNames()) {
            this.push((IValue)node.getParameter(name));
        }
    }

    private void pushConcreteSyntaxNode(ITree tree) {
        IConstructor sym;
        if (this.debug) {
            System.err.println("pushConcreteSyntaxNode: " + tree);
        }
        if (TreeAdapter.isChar(tree) || TreeAdapter.isCycle(tree) || TreeAdapter.isLiteral(tree) || TreeAdapter.isCILiteral(tree)) {
            this.spine.push(tree);
            return;
        }
        if (TreeAdapter.isAmb(tree)) {
            this.pushAmb(tree);
            return;
        }
        NonTerminalType ctype = (NonTerminalType)tree.getType();
        if (this.debug) {
            System.err.println("ctype.getSymbol=" + ctype.getSymbol());
        }
        if (SymbolAdapter.isAnyList(sym = ctype.getSymbol())) {
            int i;
            this.spine.push(tree);
            int delta = SymbolAdapter.getListSkipDelta(sym);
            sym = SymbolAdapter.getSymbol(sym);
            IList listElems = (IList)tree.get(1);
            if (this.debug) {
                for (i = 0; i < listElems.length(); ++i) {
                    System.err.println("#" + i + ": " + listElems.get(i));
                }
            }
            for (i = listElems.length() - 1; i >= 0; i -= delta) {
                if (this.debug) {
                    System.err.println("adding: " + listElems.get(i));
                }
                this.pushConcreteSyntaxNode((ITree)listElems.get(i));
            }
        } else if (SymbolAdapter.isStartSort(sym)) {
            this.pushConcreteSyntaxNode(TreeAdapter.getStartTop(tree));
        } else {
            if (this.debug) {
                System.err.println("pushConcreteSyntaxNode: appl");
            }
            this.spine.push(tree);
            IList applArgs = (IList)tree.get(1);
            int delta = SymbolAdapter.isLex(sym) ? 1 : 2;
            for (int i = applArgs.length() - 1; i >= 0; i -= delta) {
                this.pushConcreteSyntaxNode((ITree)applArgs.get(i));
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove from DescendantReader");
    }
}

