---
title: "module ValueIO"
id: ValueIO
slug: /Library//ValueIO
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Library functions for reading and writing values in textual and binary format.
#### Usage

```rascal
import ValueIO;
```

#### Dependencies
```rascal
import Type;
```


## function readValueFile {#ValueIO-readValueFile}

Read  a value from a binary file in PBF format.

```rascal
value readValueFile(loc file)
```

## function getFileLength {#ValueIO-getFileLength}

Get length of a file in number of bytes.

```rascal
int getFileLength(loc file)
```

## function readBinaryValueFile {#ValueIO-readBinaryValueFile}

Read a typed value from a binary file.

```rascal
&T readBinaryValueFile(type[&T] result, loc file)

value readBinaryValueFile(loc file)
```

## function readTextValueFile {#ValueIO-readTextValueFile}

Read a typed value from a text file.

```rascal
&T readTextValueFile(type[&T] result, loc file)

value readTextValueFile(loc file)
```

## function readTextValueFileWithEmbeddedTypes {#ValueIO-readTextValueFileWithEmbeddedTypes}

If you have written a file containing reified types, then you can use this function
  to read them back.

```rascal
&T readTextValueFileWithEmbeddedTypes(type[&T] result, loc file)
```

## function readTextValueString {#ValueIO-readTextValueString}

Parse a textual string representation of a value.

```rascal
value readTextValueString(str input)
```

## function readTextValueString {#ValueIO-readTextValueString}

Parse a textual string representation of a value and validate it against the given type.

```rascal
&T readTextValueString(type[&T] result, str input)
```

## function writeBinaryValueFile {#ValueIO-writeBinaryValueFile}

Write a value to a file using an efficient binary file format.

```rascal
void writeBinaryValueFile(loc file, value val, bool compression = true)
```

## function writeTextValueFile {#ValueIO-writeTextValueFile}

Write a value to a file using a textual file format.

```rascal
void writeTextValueFile(loc file, value val)
```

