---
title: "module analysis::m3::Registry"
id: Registry
slug: /Library/analysis/m3/Registry
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

in memory database for [analysis/m3/Core] models for resolving hyperlinks
#### Usage

```rascal
import analysis::m3::Registry;
```

#### Dependencies
```rascal
import analysis::m3::Core;
import IO;
```

#### Description


The functions in this file are used to register m3 models in a global in-memory database. When a source location is clicked this database is used used to resolve logical source locations, such as `|java+class:///java/lang/Object|` to physical source locations such as `|file:///usr/lib/blabla.java|`.


## function registerProject {#analysis-m3-Registry-registerProject}

Register an M3 model for a certain project name.

```rascal
void registerProject(loc project, M3 model)
```


The effect of registering a project is that the m3 URI resolver knows how to find the physical source location
for qualified names.

Note that [Register Project](../../..//Library/analysis/m3/Registry.md#analysis-m3-Registry-registerProject) will be called usually as a side-effect of a function that extracts a model for
a specific language.

#### Benefits


*  this enables qualified names as locations to be hyperlinks in the IDE

#### Pitfalls


*  the registry is a global store that will retain links to M3 models even when they are not in use anymore. The 
programmer should take care to call [Unregister Project](../../..//Library/analysis/m3/Registry.md#analysis-m3-Registry-unregisterProject) to prevent memory leakage.

## function unregisterProject {#analysis-m3-Registry-unregisterProject}

unregister an M3 model for a certain project name.

```rascal
void unregisterProject(loc project, M3 model)
```


The effect of unregistering a project is that all references will be
removed from the registry, clearing memory.

#### Benefits


*  this cleans up the memory used by the registry

#### Pitfalls


*  if a different model is used for unregistering than for registering,
   there could be a memory leak of remaining schemes and their respective locations.

## function unregisterProjectSchemes {#analysis-m3-Registry-unregisterProjectSchemes}

unregister an M3 model for a set of given schemes

```rascal
void unregisterProjectSchemes(loc project, set[str] schemes)
```


The effect of unregistering a project is that all references will be
removed from the registry, clearing memory.

#### Benefits


* This cleans up the memory used by the registry, and by giving all possible
   schemes for a certain language the chance is high there are not dangling
   entries afterwards.

#### Pitfalls


*  If more schemes were registered than are unregistered here, there is a
   memory leak.

