/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.visitors;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import io.usethesource.vallang.visitors.VisitorAdapter;
import java.util.Map;

public class BottomUpTransformer<E extends Throwable>
extends VisitorAdapter<IValue, E> {
    protected IValueFactory fFactory;

    public BottomUpTransformer(IValueVisitor<IValue, E> visitor, IValueFactory factory) {
        super(visitor);
        this.fFactory = factory;
    }

    @Override
    public IValue visitNode(INode o) throws E {
        for (int i = 0; i < o.arity(); ++i) {
            o = o.set(i, (IValue)o.get(i).accept(this));
        }
        return (IValue)this.fVisitor.visitNode(o);
    }

    @Override
    public IValue visitConstructor(IConstructor o) throws E {
        for (int i = 0; i < o.arity(); ++i) {
            o = o.set(i, (IValue)o.get(i).accept(this));
        }
        return (IValue)this.fVisitor.visitConstructor(o);
    }

    @Override
    public IValue visitList(IList o) throws E {
        IListWriter w = this.fFactory.listWriter();
        for (IValue elem : o) {
            w.append((IValue)elem.accept(this));
        }
        return (IValue)this.fVisitor.visitList((IList)w.done());
    }

    @Override
    public IValue visitSet(ISet o) throws E {
        ISetWriter w = this.fFactory.setWriter();
        for (IValue elem : o) {
            w.insert((IValue)elem.accept(this));
        }
        return (IValue)this.fVisitor.visitSet((ISet)w.done());
    }

    @Override
    public IValue visitMap(IMap o) throws E {
        IMapWriter w = this.fFactory.mapWriter();
        for (Map.Entry entry : () -> o.entryIterator()) {
            w.put((IValue)((IValue)entry.getKey()).accept(this), (IValue)((IValue)entry.getValue()).accept(this));
        }
        return (IValue)this.fVisitor.visitMap((IMap)w.done());
    }

    @Override
    public IValue visitTuple(ITuple o) throws E {
        for (int i = 0; i < o.arity(); ++i) {
            o = o.set(i, (IValue)o.get(i).accept(this));
        }
        return (IValue)this.fVisitor.visitTuple(o);
    }

    @Override
    public IValue visitExternal(IExternalValue externalValue) throws E {
        return (IValue)this.fVisitor.visitExternal(externalValue);
    }
}

