/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.debug.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebugEnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final Map<String, T> serializedFormToEnum = new HashMap<String, T>();
    private final Map<T, String> enumToSerializedForm = new HashMap<T, String>();

    public DebugEnumTypeAdapter(Class<T> clazz) {
        try {
            for (Enum constant : (Enum[])clazz.getEnumConstants()) {
                String name = constant.name();
                String serializedForm = this.getSerializedForm(name);
                SerializedName annotation = clazz.getField(name).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    serializedForm = annotation.value();
                    for (String alternate : annotation.alternate()) {
                        this.serializedFormToEnum.put(alternate, constant);
                    }
                }
                this.serializedFormToEnum.put(serializedForm, constant);
                this.enumToSerializedForm.put(constant, serializedForm);
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getSerializedForm(String name) {
        name = name.toLowerCase();
        Matcher m4 = Pattern.compile("_[a-z]").matcher(name);
        StringBuffer sb = new StringBuffer();
        while (m4.find()) {
            m4.appendReplacement(sb, m4.group().toUpperCase());
        }
        m4.appendTail(sb);
        return sb.toString().replace("_", "");
    }

    @Override
    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return (T)((Enum)this.serializedFormToEnum.get(in.nextString()));
    }

    @Override
    public void write(JsonWriter out, T value) throws IOException {
        out.value(value == null ? null : this.enumToSerializedForm.get(value));
    }

    public static class Factory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class<T> rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            return new DebugEnumTypeAdapter<T>(rawType);
        }
    }
}

