/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap;

import io.usethesource.vallang.ISourceLocation;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.rascalmpl.dap.SuspendedState;
import org.rascalmpl.dap.breakpoint.BreakpointsCollection;
import org.rascalmpl.debug.AbstractInterpreterEventTrigger;
import org.rascalmpl.debug.DebugHandler;
import org.rascalmpl.debug.DebugMessageFactory;
import org.rascalmpl.debug.IRascalEventListener;
import org.rascalmpl.debug.RascalEvent;

public class RascalDebugEventTrigger
extends AbstractInterpreterEventTrigger {
    private IDebugProtocolClient client;
    private final SuspendedState suspendedState;
    private final BreakpointsCollection breakpointsCollection;
    private final DebugHandler debugHandler;

    public RascalDebugEventTrigger(Object source, BreakpointsCollection breakpointsCollection, SuspendedState suspendedState, DebugHandler debugHandler) {
        super(source);
        this.breakpointsCollection = breakpointsCollection;
        this.suspendedState = suspendedState;
        this.debugHandler = debugHandler;
    }

    public void setDebugProtocolClient(IDebugProtocolClient client) {
        this.client = client;
    }

    @Override
    public void addRascalEventListener(IRascalEventListener listener) {
        throw new UnsupportedOperationException("Method 'addRascalEventListener' shouldn't be called");
    }

    @Override
    public void removeRascalEventListener(IRascalEventListener listener) {
        throw new UnsupportedOperationException("Method 'removeRascalEventListener' shouldn't be called");
    }

    @Override
    protected void fireEvent(RascalEvent event) {
        throw new UnsupportedOperationException("Method 'fireEvent' shouldn't be called");
    }

    @Override
    public void fireSuspendByBreakpointEvent(Object data) {
        if (!(data instanceof ISourceLocation)) {
            return;
        }
        ISourceLocation location = (ISourceLocation)data;
        int breakpointID = this.breakpointsCollection.getBreakpointID(location);
        if (breakpointID < 0) {
            return;
        }
        this.suspendedState.suspended();
        StoppedEventArguments stoppedEventArguments = new StoppedEventArguments();
        stoppedEventArguments.setThreadId(1);
        stoppedEventArguments.setDescription("Paused on breakpoint.");
        stoppedEventArguments.setReason("breakpoint");
        stoppedEventArguments.setHitBreakpointIds(new Integer[]{breakpointID});
        this.client.stopped(stoppedEventArguments);
    }

    @Override
    public void fireResumeEvent(RascalEvent.Detail detail) {
        this.suspendedState.resumed();
    }

    @Override
    public void fireResumeByStepOverEvent() {
        this.suspendedState.resumed();
    }

    @Override
    public void fireResumeByStepIntoEvent() {
        this.suspendedState.resumed();
    }

    @Override
    public void fireSuspendByStepEndEvent() {
        ISourceLocation currentLocation = this.suspendedState.getCurrentLocation();
        if (currentLocation.getPath().length() == 1) {
            this.debugHandler.processMessage(DebugMessageFactory.requestResumption());
            return;
        }
        this.suspendedState.suspended();
        StoppedEventArguments stoppedEventArguments = new StoppedEventArguments();
        stoppedEventArguments.setThreadId(1);
        stoppedEventArguments.setDescription("Paused on step end.");
        stoppedEventArguments.setReason("step");
        this.client.stopped(stoppedEventArguments);
    }

    @Override
    public void fireSuspendByClientRequestEvent() {
        this.suspendedState.suspended();
        StoppedEventArguments stoppedEventArguments = new StoppedEventArguments();
        stoppedEventArguments.setThreadId(1);
        stoppedEventArguments.setDescription("Paused by client.");
        stoppedEventArguments.setReason("pause");
        this.client.stopped(stoppedEventArguments);
    }

    @Override
    public void fireSuspendEvent(RascalEvent.Detail detail) {
    }
}

