/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashMap;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class GuardedPattern
extends AbstractMatchingResult {
    private Type type;
    private IMatchingResult pat;

    public GuardedPattern(IEvaluatorContext ctx, Expression.AsType x, Type type, IMatchingResult pat) {
        super(ctx, x);
        this.type = type;
        this.pat = pat;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.pat.hasNext();
    }

    @Override
    public List<IVarPattern> getVariables() {
        return this.pat.getVariables();
    }

    @Override
    public boolean mayMatch(Type subjectType, Environment env) {
        return super.mayMatch(subjectType, env) && (this.pat.mayMatch(subjectType, env) || subjectType.isSubtypeOf(RascalValueFactory.Tree) && this.pat.mayMatch(TypeFactory.getInstance().stringType(), env));
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        Environment env = this.ctx.getCurrentEnvt();
        if (this.type instanceof NonTerminalType && this.pat.getType(env, null).isSubtypeOf(this.tf.stringType()) && subject.getValue().getType().isSubtypeOf(RascalValueFactory.Tree)) {
            if (subject.getValue().getType().isSubtypeOf(this.type)) {
                subject = ResultFactory.makeResult(this.tf.stringType(), this.ctx.getValueFactory().string(TreeAdapter.yield((IConstructor)subject.getValue())), this.ctx);
                this.pat.initMatch(subject);
                this.hasNext = this.pat.hasNext();
            } else {
                this.hasNext = false;
            }
        } else {
            this.pat.initMatch(subject);
            this.hasNext = this.pat.getType(env, null).equivalent(this.type);
        }
    }

    @Override
    public boolean next() {
        return this.pat.next();
    }
}

