/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.matching.QualifiedNamePattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.RedeclaredVariable;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.semantics.dynamic.QualifiedName;

public class MultiVariablePattern
extends QualifiedNamePattern {
    public MultiVariablePattern(IEvaluatorContext ctx, Expression.MultiVariable x, QualifiedName name) {
        super(ctx, x, name);
    }

    public MultiVariablePattern(IEvaluatorContext ctx, Expression.Splice x, QualifiedName name) {
        super(ctx, x, name);
    }

    @Override
    public boolean next() {
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        if (this.debug) {
            System.err.println("AbstractPatternMultiVariablePattern.match: " + this.name);
        }
        if (this.anonymous) {
            return true;
        }
        if (this.iWroteItMySelf) {
            this.ctx.getCurrentEnvt().storeVariable(((QualifiedName.Default)this.name).lastName(), (Result<IValue>)this.subject);
            return true;
        }
        Result<IValue> varRes = this.ctx.getCurrentEnvt().getSimpleVariable(this.name);
        if (varRes == null) {
            this.declaredType = this.subject.getStaticType();
            if (!this.ctx.getCurrentEnvt().declareVariable(this.declaredType, this.getName())) {
                throw new RedeclaredVariable(this.getName(), this.ctx.getCurrentAST());
            }
            this.ctx.getCurrentEnvt().storeVariable(((QualifiedName.Default)this.name).lastName(), (Result<IValue>)this.subject);
            this.iWroteItMySelf = true;
            return true;
        }
        if (varRes.getValue() == null) {
            this.declaredType = varRes.getStaticType();
            if (!this.ctx.getCurrentEnvt().declareVariable(this.declaredType, this.getName())) {
                throw new RedeclaredVariable(this.getName(), this.ctx.getCurrentAST());
            }
            this.ctx.getCurrentEnvt().storeVariable(((QualifiedName.Default)this.name).lastName(), (Result<IValue>)this.subject);
            this.iWroteItMySelf = true;
            return true;
        }
        if (this.debug) {
            System.err.printf("subject.getType() = %s, varRes.getType() = %s\n", this.subject.getValue().getType(), varRes.getStaticType());
        }
        if (this.subject.getValue().getType().isSubtypeOf(varRes.getStaticType())) {
            if (this.debug) {
                System.err.println("returns " + this.subject.equals(varRes));
            }
            return this.subject.getValue().match(varRes.getValue());
        }
        return false;
    }

    @Override
    public String toString() {
        return Names.fullName(this.name);
    }
}

