/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;

public class Messages {
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final IValueFactory vf = IRascalValueFactory.getInstance();
    public static final TypeStore ts = new TypeStore(new TypeStore[0]);
    public static final Type Message = tf.abstractDataType(ts, "Message", new Type[0]);
    private static final Type Message_info = tf.constructor(ts, Message, "info", tf.stringType(), "msg", tf.sourceLocationType(), "at");
    private static final Type Message_warning = tf.constructor(ts, Message, "warning", tf.stringType(), "msg", tf.sourceLocationType(), "at");
    private static final Type Message_error = tf.constructor(ts, Message, "error", tf.stringType(), "msg", tf.sourceLocationType(), "at");

    public static IConstructor info(String message, ISourceLocation loc) {
        return Messages.message(Message_info, message, loc);
    }

    public static IConstructor warning(String message, ISourceLocation loc) {
        return Messages.message(Message_warning, message, loc);
    }

    public static IConstructor error(String message, ISourceLocation loc) {
        return Messages.message(Message_error, message, loc);
    }

    private static IConstructor message(Type type, String message, ISourceLocation loc) {
        return vf.constructor(type, vf.string(message), loc);
    }

    public static IConstructor addCause(IConstructor msg, String cause, ISourceLocation loc) {
        if (cause == null || cause.isEmpty()) {
            return msg;
        }
        IList causes = (IList)msg.asWithKeywordParameters().getParameter("causes");
        causes = causes == null ? vf.list(Messages.info(cause, loc)) : causes.append(Messages.info(cause, loc));
        return msg.asWithKeywordParameters().setParameter("causes", causes);
    }

    public static boolean isError(IValue v) {
        return v instanceof IConstructor && ((IConstructor)v).getConstructorType() == Message_error;
    }

    public static boolean isWarning(IValue v) {
        return v instanceof IConstructor && ((IConstructor)v).getConstructorType() == Message_warning;
    }

    public static boolean isInfo(IValue v) {
        return v instanceof IConstructor && ((IConstructor)v).getConstructorType() == Message_info;
    }

    public Messages(IValueFactory ignored) {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IString write(IList messsages, ISourceLocation root) {
        try (StringWriter str = new StringWriter();){
            PrintWriter writer = new PrintWriter(str);
            try {
                Messages.write(messsages, root, writer);
                writer.flush();
                IString iString = vf.string(str.toString());
                writer.close();
                return iString;
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e);
        }
    }

    public static void write(IList messages, PrintWriter out) {
        Messages.write(messages, null, out);
    }

    public static void write(IList messages, @Nullable ISourceLocation root, PrintWriter out) {
        int maxLine = 0;
        int maxColumn = 0;
        for (IValue error : messages) {
            ISourceLocation loc = (ISourceLocation)((IConstructor)error).get("at");
            if (!loc.hasLineColumn()) continue;
            maxLine = Math.max(loc.getBeginLine(), maxLine);
            maxColumn = Math.max(loc.getBeginColumn(), maxColumn);
        }
        int lineWidth = (int)Math.log10(maxLine + 1) + 1;
        int colWidth = (int)Math.log10(maxColumn + 1) + 1;
        Stream<IConstructor> sortedStream = messages.stream().map(IConstructor.class::cast).sorted((m1, m22) -> {
            ISourceLocation l1 = (ISourceLocation)m1.get("at");
            ISourceLocation l2 = (ISourceLocation)m22.get("at");
            if (!l1.getScheme().equals(l2.getScheme())) {
                return l1.getScheme().compareTo(l2.getScheme());
            }
            if (!l1.getAuthority().equals(l2.getAuthority())) {
                return l1.getAuthority().compareTo(l2.getAuthority());
            }
            if (!l1.getPath().equals(l2.getPath())) {
                return l1.getPath().compareTo(l2.getPath());
            }
            if (l1.hasLineColumn() && l2.hasLineColumn()) {
                if (l1.getBeginLine() == l2.getBeginLine()) {
                    return Integer.compare(l1.getBeginColumn(), l2.getBeginColumn());
                }
                return Integer.compare(l1.getBeginLine(), l2.getBeginLine());
            }
            if (l1.hasOffsetLength() && l2.hasOffsetLength()) {
                return Integer.compare(l1.getOffset(), l2.getOffset());
            }
            if (l1.hasOffsetLength()) {
                return -1;
            }
            if (l2.hasOffsetLength()) {
                return 1;
            }
            return 0;
        });
        for (IConstructor msg : sortedStream.collect(Collectors.toList())) {
            IList causes;
            String type = msg.getName();
            boolean isError = type.equals("error");
            boolean isWarning = type.equals("warning");
            String output = Messages.getMessageString(root, lineWidth, colWidth, msg);
            if (isError) {
                out.println("[ERROR] " + output);
            } else if (isWarning) {
                out.println("[WARNING] " + output);
            } else {
                out.println("[INFO] " + output);
            }
            if ((causes = (IList)msg.asWithKeywordParameters().getParameter("causes")) == null) continue;
            maxLine = 0;
            maxColumn = 0;
            for (IValue error : causes) {
                ISourceLocation loc = (ISourceLocation)((IConstructor)error).get("at");
                if (!loc.hasLineColumn()) continue;
                maxLine = Math.max(loc.getBeginLine(), maxLine);
                maxColumn = Math.max(loc.getBeginColumn(), maxColumn);
            }
            for (IValue cause : causes) {
                out.println("    * " + Messages.getMessageString(root, lineWidth, colWidth, (IConstructor)cause));
            }
        }
        out.flush();
    }

    private static String getMessageString(ISourceLocation root, int lineWidth, int colWidth, IConstructor msg) {
        ISourceLocation loc = (ISourceLocation)msg.get("at");
        int col = 0;
        int line = 0;
        if (loc.hasLineColumn()) {
            col = loc.getBeginColumn();
            line = loc.getBeginLine();
        }
        ISourceLocation iSourceLocation = loc = root != null ? URIUtil.relativize(root, loc) : loc;
        return loc.getPath().equals("/") || loc.getPath().isEmpty() ? ((IString)msg.get("msg")).getValue() : (root != null ? loc.getPath().substring(1) : loc) + (String)(line == 0 && col == 0 ? "" : ":" + String.format("%0" + lineWidth + "d", line) + ":" + String.format("%0" + colWidth + "d", col)) + ": " + ((IString)msg.get("msg")).getValue();
    }
}

