/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.IOException;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.utils.Timing;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.util.HeapDumper;

public class Benchmark {
    private final IValueFactory values;

    public Benchmark(IValueFactory values) {
        this.values = values;
    }

    public IInteger getFreeMemory() {
        return this.values.integer(Runtime.getRuntime().freeMemory());
    }

    public IInteger getTotalMemory() {
        return this.values.integer(Runtime.getRuntime().totalMemory());
    }

    public IInteger getMaxMemory() {
        return this.values.integer(Runtime.getRuntime().maxMemory());
    }

    public void heapDump(ISourceLocation loc, IBool live) {
        try {
            loc = URIResolverRegistry.getInstance().logicalToPhysical(loc);
            if (!"file".equals(loc.getScheme())) {
                throw RuntimeExceptionFactory.illegalArgument(loc, null, null);
            }
            HeapDumper.dumpHeap(loc.getPath(), live.getValue());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e);
        }
    }

    public IValue userTime() {
        return this.values.integer(Timing.getUserTime());
    }

    public IValue systemTime() {
        return this.values.integer(Timing.getSystemTime());
    }

    public IValue cpuTime() {
        return this.values.integer(Timing.getCpuTime());
    }

    public IValue realTime() {
        return this.values.integer(System.currentTimeMillis());
    }

    public IValue getNanoTime() {
        return this.values.integer(System.nanoTime());
    }

    public IValue getMilliTime() {
        return this.values.integer(System.currentTimeMillis());
    }

    public void gc() {
        System.gc();
    }
}

