/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.traverse;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rascalmpl.runtime.traverse.ITraverseSpecialization;
import org.rascalmpl.runtime.traverse.TraversalState;
import org.rascalmpl.runtime.traverse.TraverseOnce;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class TraverseOnceRebuild
extends TraverseOnce
implements ITraverseSpecialization {
    private static final Map<String, IValue> emptyAnnotationsMap = new HashMap<String, IValue>();

    public TraverseOnceRebuild(IValueFactory vf) {
        super(vf);
    }

    @Override
    public IValue traverseTupleOnce(IValue subject, TraversalState tr) {
        ITuple tuple = (ITuple)subject;
        int arity = tuple.arity();
        boolean hasMatched = false;
        boolean hasChanged = false;
        IValue[] args = new IValue[arity];
        for (int i = 0; i < arity; ++i) {
            tr.setMatchedAndChanged(false, false);
            args[i] = tr.traverse.once(tuple.get(i), tr);
            hasMatched |= tr.hasMatched();
            hasChanged |= tr.hasChanged();
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        return this.vf.tuple(args);
    }

    @Override
    public IValue traverseADTOnce(IValue subject, TraversalState tr) {
        IConstructor cons = (IConstructor)subject;
        boolean hasKwParams = cons.mayHaveKeywordParameters() && cons.asWithKeywordParameters().hasParameters();
        int arity = cons.arity();
        if (arity == 0 && !hasKwParams) {
            return subject;
        }
        boolean hasChanged = false;
        boolean hasMatched = false;
        IValue[] args = new IValue[arity];
        for (int i = 0; i < arity; ++i) {
            IValue child = cons.get(i);
            tr.setMatchedAndChanged(false, false);
            args[i] = tr.traverse.once(child, tr);
            hasChanged |= tr.hasChanged();
            hasMatched |= tr.hasMatched();
        }
        HashMap<String, IValue> kwParams = null;
        if (hasKwParams) {
            kwParams = new HashMap<String, IValue>();
            IWithKeywordParameters<? extends IConstructor> consKw = cons.asWithKeywordParameters();
            for (String kwName : consKw.getParameterNames()) {
                Object val = consKw.getParameter(kwName);
                tr.setMatchedAndChanged(false, false);
                IValue newVal = tr.traverse.once((IValue)val, tr);
                kwParams.put(kwName, newVal);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        if (tr.hasChanged()) {
            return this.rebuild(subject, args, hasKwParams ? kwParams : emptyAnnotationsMap);
        }
        return subject;
    }

    @Override
    public IValue traverseConcreteTreeOnce(IValue subject, TraversalState tr) {
        ITree tree = (ITree)subject;
        if (tree.isAppl()) {
            return this.traverseApplOnce(tr, tree);
        }
        if (tree.isAmb()) {
            return this.traverseAmbOnce(tr, tree);
        }
        if (tree.isChar()) {
            return tree;
        }
        assert (tree.isCycle());
        return tree;
    }

    private IValue traverseApplOnce(TraversalState tr, ITree tree) {
        IList list = TreeAdapter.getArgs(tree);
        int len = list.length();
        IValue[] args = new IValue[2];
        if (len > 0) {
            args[0] = TreeAdapter.getProduction(tree);
            IListWriter w = this.vf.listWriter();
            boolean hasChanged = false;
            boolean hasMatched = false;
            if (TreeAdapter.isTop(tree)) {
                tr.setMatchedAndChanged(false, false);
                w.append(tr.traverse.once(list.get(0), tr));
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                w.append(tr.traverse.once(list.get(1), tr));
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                w.append(tr.traverse.once(list.get(2), tr));
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            } else {
                for (int i = 0; i < len; ++i) {
                    IValue elem = list.get(i);
                    if (i % 2 == 0) {
                        tr.setMatchedAndChanged(false, false);
                        w.append(tr.traverse.once(elem, tr));
                        hasChanged |= tr.hasChanged();
                        hasMatched |= tr.hasMatched();
                        continue;
                    }
                    w.append(list.get(i));
                }
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            args[1] = w.done();
        } else {
            args[1] = list;
        }
        if (tr.hasChanged()) {
            return this.vf.constructor(RascalValueFactory.Tree_Appl, args);
        }
        return tree;
    }

    private IValue traverseAmbOnce(TraversalState tr, ITree tree) {
        tr.setMatchedAndChanged(false, false);
        boolean hasChanged = false;
        boolean hasMatched = false;
        ISetWriter newAlts = this.vf.setWriter();
        for (IValue alt : tree.getAlternatives()) {
            tr.setMatchedAndChanged(false, false);
            newAlts.insert(tr.traverse.once(alt, tr));
            hasChanged |= tr.hasChanged();
            hasMatched |= tr.hasMatched();
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        if (hasChanged) {
            return IRascalValueFactory.getInstance().amb((ISet)newAlts.done());
        }
        return tree;
    }

    @Override
    public IValue traverseMapOnce(IValue subject, TraversalState tr) {
        IMap map = (IMap)subject;
        if (!map.isEmpty()) {
            Iterator<Map.Entry<IValue, IValue>> iter = map.entryIterator();
            boolean hasChanged = false;
            boolean hasMatched = false;
            int mapSize = map.size();
            IValue[] keys = new IValue[mapSize];
            IValue[] vals = new IValue[mapSize];
            int i = 0;
            while (iter.hasNext()) {
                Map.Entry<IValue, IValue> entry = iter.next();
                tr.setMatchedAndChanged(false, false);
                keys[i] = tr.traverse.once(entry.getKey(), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                vals[i] = tr.traverse.once(entry.getValue(), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                ++i;
            }
            tr.setChanged(hasChanged);
            tr.setMatched(hasMatched);
            if (hasChanged) {
                IMapWriter w = this.vf.mapWriter();
                for (int j = 0; j < mapSize; ++j) {
                    w.put(keys[j], vals[j]);
                }
                return w.done();
            }
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseSetOnce(IValue subject, TraversalState tr) {
        ISet set = (ISet)subject;
        if (!set.isEmpty()) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            int setSize = set.size();
            IValue[] vals = new IValue[setSize];
            int i = 0;
            for (IValue v : set) {
                tr.setMatchedAndChanged(false, false);
                vals[i] = tr.traverse.once(v, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                ++i;
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            if (hasChanged) {
                ISetWriter w = this.vf.setWriter();
                for (int j = 0; j < setSize; ++j) {
                    w.insert(vals[j]);
                }
                return w.done();
            }
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseListOnce(IValue subject, TraversalState tr) {
        IList list = (IList)subject;
        int len = list.length();
        if (len > 0) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            IListWriter w = this.vf.listWriter();
            for (int i = 0; i < len; ++i) {
                IValue elem = list.get(i);
                tr.setMatchedAndChanged(false, false);
                elem = tr.traverse.once(elem, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                w.append(elem);
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            if (hasChanged) {
                return w.done();
            }
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseNodeOnce(IValue subject, TraversalState tr) {
        boolean hasKwParams;
        IValue result = subject;
        INode node = (INode)subject;
        int arity = node.arity();
        boolean bl = hasKwParams = node.mayHaveKeywordParameters() && node.asWithKeywordParameters().hasParameters();
        if (arity == 0 && !hasKwParams) {
            result = subject;
        }
        boolean hasChanged = false;
        boolean hasMatched = false;
        IValue[] args = new IValue[node.arity()];
        HashMap<String, IValue> kwParams = null;
        for (int i = 0; i < arity; ++i) {
            IValue child = node.get(i);
            tr.setMatchedAndChanged(false, false);
            args[i] = tr.traverse.once(child, tr);
            hasChanged |= tr.hasChanged();
            hasMatched |= tr.hasMatched();
        }
        if (hasKwParams) {
            kwParams = new HashMap<String, IValue>();
            IWithKeywordParameters<? extends INode> nodeKw = node.asWithKeywordParameters();
            for (String kwName : nodeKw.getParameterNames()) {
                Object val = nodeKw.getParameter(kwName);
                tr.setMatchedAndChanged(false, false);
                IValue newVal = tr.traverse.once((IValue)val, tr);
                kwParams.put(kwName, newVal);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        if (hasChanged) {
            result = kwParams == null ? this.vf.node(node.getName(), args) : this.vf.node(node.getName(), args, kwParams);
        }
        return result;
    }

    @Override
    public IValue traverseStringOnce(IValue subject, TraversalState tr) {
        boolean hasMatched = tr.hasMatched();
        boolean hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        IValue res = this.traverseString(subject, tr);
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return res;
    }

    private IValue traverseString(IValue subject, TraversalState tr) {
        IString subjectIString = (IString)subject;
        String subjectString = subjectIString.getValue();
        int len = subjectString.length();
        int subjectCursor = 0;
        boolean hasMatched = false;
        boolean hasChanged = false;
        StringBuilder replacementString = new StringBuilder(len);
        while (subjectCursor < len) {
            tr.setMatchedAndChanged(false, false);
            tr.setBegin(0);
            tr.setEnd(len);
            String repl = ((IString)this.traverseTop(this.vf.string(subjectString.substring(subjectCursor, len)), tr)).getValue();
            if (tr.hasMatched()) {
                if (tr.getBegin() > 0) {
                    replacementString.append(subjectString.substring(subjectCursor, subjectCursor + tr.getBegin()));
                }
                replacementString.append(repl);
                subjectCursor += tr.getEnd();
            } else {
                replacementString.append(subjectString.substring(subjectCursor, subjectCursor + 1));
                ++subjectCursor;
            }
            hasMatched |= tr.hasMatched();
            hasChanged |= tr.hasChanged();
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        if (!tr.hasChanged()) {
            return subject;
        }
        return this.vf.string(replacementString.toString());
    }

    private INode rebuild(IValue subject, IValue[] args, Map<String, IValue> changedKwParams) {
        Map<String, IValue> givenKwParams;
        Map<String, IValue> map = givenKwParams = subject.mayHaveKeywordParameters() ? subject.asWithKeywordParameters().getParameters() : emptyAnnotationsMap;
        if (subject.getType().isAbstractData()) {
            return this.vf.constructor(((IConstructor)subject).getConstructorType(), args, changedKwParams.isEmpty() ? givenKwParams : changedKwParams);
        }
        return this.vf.node(((INode)subject).getName(), args, changedKwParams.isEmpty() ? givenKwParams : changedKwParams);
    }
}

