/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tasks;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.tasks.ITask;
import org.rascalmpl.tasks.ITaskRegistry;
import org.rascalmpl.tasks.ITransaction;
import org.rascalmpl.tasks.TaskRegistry;

public class PDBValueTaskRegistry
extends TaskRegistry<Type, IValue, IValue>
implements ITaskRegistry<Type, IValue, IValue> {
    private static volatile PDBValueTaskRegistry instance = null;
    private Map<Type, Map<Type, ITask<Type, IValue, IValue>>> keyedProducers = new HashMap<Type, Map<Type, ITask<Type, IValue, IValue>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PDBValueTaskRegistry getRegistry() {
        if (instance != null) return instance;
        Class<PDBValueTaskRegistry> clazz = PDBValueTaskRegistry.class;
        synchronized (PDBValueTaskRegistry.class) {
            if (instance != null) return instance;
            instance = new PDBValueTaskRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PDBValueTaskRegistry() {
    }

    @Override
    public ITask<Type, IValue, IValue> getProducer(Type key, IValue name) {
        this.lock.lock();
        try {
            Map<Type, ITask<Type, IValue, IValue>> producerMap = this.keyedProducers.get(key);
            if (producerMap != null) {
                Type nameType = name.getType();
                if (producerMap.containsKey(nameType)) {
                    ITask<Type, IValue, IValue> iTask = producerMap.get(nameType);
                    return iTask;
                }
                for (Map.Entry<Type, ITask<Type, IValue, IValue>> t2 : producerMap.entrySet()) {
                    if (!nameType.isSubtypeOf(t2.getKey())) continue;
                    ITask<Type, IValue, IValue> iTask = t2.getValue();
                    return iTask;
                }
            }
            throw new ImplementationError("No suitable producer found for " + key + "(" + name + ")");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean produce(IRascalMonitor monitor, ITransaction<Type, IValue, IValue> tr, Type key, IValue name) {
        ITask<Type, IValue, IValue> producer = null;
        this.lock.lock();
        try {
            producer = this.getProducer(key, name);
        }
        finally {
            this.lock.unlock();
        }
        if (producer == null) {
            throw new ImplementationError("No registered fact producer for " + key.toString());
        }
        return producer.produce(monitor, tr, key, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProducer(ITask<Type, IValue, IValue> producer) {
        this.lock.lock();
        try {
            for (Type key : producer.getKeys()) {
                if (key.isTuple()) {
                    Type key1 = key.getFieldType(0);
                    Type key2 = key.getFieldType(1);
                    Map<Type, ITask<Type, IValue, IValue>> map = this.keyedProducers.get(key1);
                    if (map == null) {
                        map = new HashMap<Type, ITask<Type, IValue, IValue>>();
                    }
                    map.put(key2, producer);
                    this.keyedProducers.put(key1, map);
                    continue;
                }
                this.producers.put(key, producer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProducer(ITask<Type, IValue, IValue> producer) {
        this.lock.lock();
        try {
            for (Type key : producer.getKeys()) {
                if (key.isTuple()) {
                    Type key1 = key.getFieldType(0);
                    Map<Type, ITask<Type, IValue, IValue>> map = this.keyedProducers.get(key1);
                    if (map == null) continue;
                    for (Map.Entry<Type, ITask<Type, IValue, IValue>> entry : map.entrySet()) {
                        if (!entry.getValue().equals(producer)) continue;
                        map.remove(entry.getKey());
                    }
                    if (map.isEmpty()) {
                        this.keyedProducers.remove(key1);
                        continue;
                    }
                    this.keyedProducers.put(key1, map);
                    continue;
                }
                if (this.producers.get(key) != producer) continue;
                this.producers.remove(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<Type> getKeys() {
        this.lock.lock();
        try {
            HashSet<Type> set = new HashSet<Type>();
            set.addAll(this.keyedProducers.keySet());
            set.addAll(super.getKeys());
            HashSet<Type> hashSet = set;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.keyedProducers.clear();
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

