/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.rascalmpl.uri.ISourceLocationOutput;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public interface ISourceLocationOutputRewriter
extends ISourceLocationOutput {
    public URIResolverRegistry reg();

    public ISourceLocation rewrite(ISourceLocation var1) throws IOException;

    @Override
    default public OutputStream getOutputStream(ISourceLocation uri, boolean append) throws IOException {
        ISourceLocation parent = this.rewrite(URIUtil.getParentLocation(uri));
        return URIResolverRegistry.getInstance().getOutputStream(URIUtil.getChildLocation(parent, URIUtil.getLocationName(uri)), append);
    }

    @Override
    default public void mkDirectory(ISourceLocation uri) throws IOException {
        ISourceLocation parent = this.rewrite(URIUtil.getParentLocation(uri));
        URIResolverRegistry.getInstance().mkDirectory(URIUtil.getChildLocation(parent, URIUtil.getLocationName(uri)));
    }

    @Override
    default public FileChannel getWritableOutputStream(ISourceLocation uri, boolean append) throws IOException {
        return this.reg().getWriteableFileChannel(this.rewrite(uri), append);
    }

    @Override
    default public void remove(ISourceLocation uri) throws IOException {
        this.reg().remove(this.rewrite(uri), false);
    }

    @Override
    default public Charset getCharset(ISourceLocation uri) throws IOException {
        return this.reg().getCharset(this.rewrite(uri));
    }

    @Override
    public String scheme();
}

