/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.parsetrees.visitors;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.visitors.IdentityVisitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;

public abstract class TreeVisitor<E extends Throwable>
extends IdentityVisitor<E> {
    @Override
    public INode visitConstructor(IConstructor o) throws E {
        if (o.getType().isSubtypeOf(RascalValueFactory.Tree)) {
            Type alt = o.getConstructorType();
            if (alt == RascalValueFactory.Tree_Appl) {
                return this.visitTreeAppl((ITree)o);
            }
            if (alt == RascalValueFactory.Tree_Amb) {
                return this.visitTreeAmb((ITree)o);
            }
            if (alt == RascalValueFactory.Tree_Char) {
                return this.visitTreeChar((ITree)o);
            }
            if (alt == RascalValueFactory.Tree_Cycle) {
                return this.visitTreeCycle((ITree)o);
            }
            throw new ImplementationError("TreeVisitor does not implement: " + alt);
        }
        return o;
    }

    public abstract ITree visitTreeAppl(ITree var1) throws E;

    public abstract ITree visitTreeAmb(ITree var1) throws E;

    public abstract ITree visitTreeChar(ITree var1) throws E;

    public abstract ITree visitTreeCycle(ITree var1) throws E;
}

