/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.visitors.IValueVisitor;

public interface IInteger
extends INumber {
    @Override
    default public int getMatchFingerprint() {
        if (this.signum() == 0) {
            return 104431;
        }
        return this.hashCode();
    }

    @Override
    public IInteger add(IInteger var1);

    @Override
    public IInteger subtract(IInteger var1);

    @Override
    public IInteger multiply(IInteger var1);

    public IInteger divide(IInteger var1);

    public IRational divide(IRational var1);

    public IInteger remainder(IInteger var1);

    @Override
    public IInteger negate();

    public IInteger mod(IInteger var1);

    @Override
    public IReal toReal(int var1);

    @Override
    public IBool less(IInteger var1);

    @Override
    public IBool greater(IInteger var1);

    @Override
    public IBool lessEqual(IInteger var1);

    @Override
    public IBool greaterEqual(IInteger var1);

    public String getStringRepresentation();

    public byte[] getTwosComplementRepresentation();

    public int intValue() throws ArithmeticException;

    public long longValue() throws ArithmeticException;

    public double doubleValue();

    public int compare(IInteger var1);

    @Override
    public int signum();

    @Override
    public IInteger abs();

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitInteger(this);
    }
}

