/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.Set;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.EmptySet;
import io.usethesource.vallang.impl.persistent.PersistentSetFactory;
import io.usethesource.vallang.impl.persistent.PersistentSetRelation;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.util.AbstractTypeBag;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PersistentHashSet
implements ISet {
    private @Nullable Type cachedSetType = null;
    private final AbstractTypeBag elementTypeBag;
    private final Set.Immutable<IValue> content;

    PersistentHashSet(AbstractTypeBag elementTypeBag, Set.Immutable<IValue> content) {
        this.elementTypeBag = Objects.requireNonNull(elementTypeBag);
        this.content = Objects.requireNonNull(content);
        assert (PersistentHashSet.checkDynamicType(elementTypeBag, content));
        assert (elementTypeBag.lub() != TF.voidType() && !content.isEmpty());
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    private static final boolean checkDynamicType(AbstractTypeBag elementTypeBag, Set.Immutable<IValue> content) {
        AbstractTypeBag expectedElementTypeBag = content.stream().map(IValue::getType).collect(AbstractTypeBag.toTypeBag());
        boolean expectedTypesEqual = expectedElementTypeBag.equals(elementTypeBag);
        return expectedTypesEqual;
    }

    public ISetWriter writer() {
        return ValueFactory.getInstance().setWriter();
    }

    @Override
    public Type getType() {
        if (this.cachedSetType == null) {
            this.cachedSetType = TF.setType(this.elementTypeBag.lub());
        }
        return this.cachedSetType;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public ISet insert(IValue value) {
        Set.Immutable<IValue> contentNew = this.content.__insert(value);
        if (this.content == contentNew) {
            return this;
        }
        AbstractTypeBag bagNew = this.elementTypeBag.increase(value.getType());
        return PersistentSetFactory.from(bagNew, contentNew);
    }

    @Override
    public ISet delete(IValue value) {
        Set.Immutable<IValue> contentNew = this.content.__remove(value);
        if (this.content == contentNew) {
            return this;
        }
        AbstractTypeBag bagNew = this.elementTypeBag.decrease(value.getType());
        return PersistentSetFactory.from(bagNew, contentNew);
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public boolean contains(IValue value) {
        return this.content.contains(value);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.iterator();
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PersistentHashSet) {
            PersistentHashSet that = (PersistentHashSet)other;
            if (this.getType() != that.getType()) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            return this.content.equals(that.content);
        }
        if (other instanceof ISet) {
            return this.defaultEquals(other);
        }
        return false;
    }

    @Override
    public ISet union(ISet other) {
        if (other == this) {
            return this;
        }
        if (other instanceof PersistentHashSet) {
            Set.Immutable<IValue> two;
            AbstractTypeBag bag;
            Set.Immutable<IValue> one;
            PersistentHashSet def;
            PersistentHashSet that = (PersistentHashSet)other;
            if (that.size() >= this.size()) {
                def = that;
                one = that.content;
                bag = that.elementTypeBag;
                two = this.content;
            } else {
                def = this;
                one = this.content;
                bag = this.elementTypeBag;
                two = that.content;
            }
            Set.Transient<IValue> tmp = one.asTransient();
            boolean modified = false;
            for (IValue key : two) {
                if (!tmp.__insert(key)) continue;
                modified = true;
                bag = bag.increase(key.getType());
            }
            if (modified) {
                return PersistentSetFactory.from(bag, tmp.freeze());
            }
            return def;
        }
        return ISet.super.union(other);
    }

    @Override
    public ISet intersect(ISet other) {
        if (other == this) {
            return this;
        }
        if (other instanceof PersistentHashSet) {
            Set.Immutable<IValue> two;
            AbstractTypeBag bag;
            Set.Immutable<IValue> one;
            PersistentHashSet def;
            PersistentHashSet that = (PersistentHashSet)other;
            if (that.size() >= this.size()) {
                def = this;
                one = this.content;
                bag = this.elementTypeBag;
                two = that.content;
            } else {
                def = that;
                one = that.content;
                bag = that.elementTypeBag;
                two = this.content;
            }
            Set.Transient<IValue> tmp = one.asTransient();
            boolean modified = false;
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                IValue key = (IValue)it.next();
                if (two.contains(key)) continue;
                it.remove();
                modified = true;
                bag = bag.decrease(key.getType());
            }
            if (modified) {
                return PersistentSetFactory.from(bag, tmp.freeze());
            }
            return def;
        }
        return ISet.super.intersect(other);
    }

    @Override
    public ISet subtract(ISet other) {
        if (other == this) {
            return EmptySet.EMPTY_SET;
        }
        if (other == null) {
            return this;
        }
        if (other instanceof PersistentHashSet) {
            PersistentHashSet that = (PersistentHashSet)other;
            PersistentHashSet def = this;
            Set.Immutable<IValue> one = this.content;
            AbstractTypeBag bag = this.elementTypeBag;
            Set.Immutable<IValue> two = that.content;
            Set.Transient<IValue> tmp = one.asTransient();
            boolean modified = false;
            for (IValue key : two) {
                if (!tmp.__remove(key)) continue;
                modified = true;
                bag = bag.decrease(key.getType());
            }
            if (modified) {
                return PersistentSetFactory.from(bag, tmp.freeze());
            }
            return def;
        }
        return ISet.super.subtract(other);
    }

    @Override
    public IRelation<ISet> asRelation() {
        return new PersistentSetRelation(this);
    }
}

