/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.EmptySet;
import io.usethesource.vallang.impl.persistent.PersistentHashIndexedBinaryRelation;
import io.usethesource.vallang.impl.persistent.PersistentHashSet;
import io.usethesource.vallang.impl.persistent.SetWriter;
import io.usethesource.vallang.impl.persistent.ValueCollectors;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.util.AbstractTypeBag;

class PersistentSetFactory {
    PersistentSetFactory() {
    }

    static final ISet from(Set.Immutable<IValue> content) {
        if (content.isEmpty()) {
            return EmptySet.EMPTY_SET;
        }
        AbstractTypeBag elementTypeBag = content.stream().map(IValue::getType).collect(AbstractTypeBag.toTypeBag());
        return PersistentSetFactory.from(elementTypeBag, content);
    }

    static final ISet from(AbstractTypeBag keyTypeBag, AbstractTypeBag valTypeBag, SetMultimap.Immutable<IValue, IValue> content) {
        if (content.isEmpty()) {
            return EmptySet.EMPTY_SET;
        }
        return new PersistentHashIndexedBinaryRelation(keyTypeBag, valTypeBag, content);
    }

    static final ISet from(AbstractTypeBag elementTypeBag, Set.Immutable<IValue> content) {
        Type elementType = elementTypeBag.lub();
        if (elementType.isBottom()) {
            return EmptySet.EMPTY_SET;
        }
        if (SetWriter.isTupleOfArityTwo.test(elementType)) {
            return content.stream().map(SetWriter.asInstanceOf(ITuple.class)).collect(ValueCollectors.toSetMultimap(tuple -> tuple.get(0), tuple -> tuple.get(1)));
        }
        return new PersistentHashSet(elementTypeBag, content);
    }
}

