/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.impl.persistent.EmptySet;
import io.usethesource.vallang.impl.persistent.PersistentSetFactory;
import io.usethesource.vallang.impl.persistent.Tuple;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.util.AbstractTypeBag;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class SetWriter
implements ISetWriter {
    public static final boolean USE_MULTIMAP_BINARY_RELATIONS = true;
    public static Predicate<Type> isTuple = type -> type.isTuple();
    public static Predicate<Type> arityEqualsTwo = type -> type.getArity() == 2;
    public static Predicate<Type> isTupleOfArityTwo = isTuple.and(arityEqualsTwo);
    protected AbstractTypeBag elementTypeBag;
    protected @MonotonicNonNull ISet constructedSet;
    private Type leastUpperBound = TypeFactory.getInstance().voidType();
    private @MonotonicNonNull Builder builder;
    private final BiFunction<IValue, IValue, ITuple> constructTuple;

    SetWriter(BiFunction<IValue, IValue, ITuple> constructTuple) {
        this.constructTuple = constructTuple;
        this.elementTypeBag = AbstractTypeBag.of(new Type[0]);
    }

    private void put(IValue element) {
        Type elementType = element.getType();
        if (this.builder == null || elementType != this.leastUpperBound) {
            if (elementType.isTuple() && elementType.getArity() == 2) {
                if (this.builder == null) {
                    this.builder = new MultiMapBuilder();
                }
            } else if (this.builder == null) {
                this.builder = new SetBuilder();
            } else if (this.builder instanceof MultiMapBuilder) {
                MultiMapBuilder oldBuilder = (MultiMapBuilder)this.builder;
                Builder finalSetBuilder = this.builder = new SetBuilder();
                oldBuilder.map.tupleStream(this.constructTuple).forEach(t2 -> finalSetBuilder.put((IValue)t2, t2.getType()));
            }
        }
        this.builder.put(element, elementType);
        this.leastUpperBound = this.leastUpperBound.lub(elementType);
    }

    @Override
    public void insert(IValue ... values) throws FactTypeUseException {
        this.checkMutation();
        Arrays.stream(values).forEach(this::put);
    }

    @Override
    public void insertAll(Iterable<? extends IValue> collection) throws FactTypeUseException {
        this.checkMutation();
        collection.forEach(this::put);
    }

    @Override
    public ISet done() {
        if (this.constructedSet != null) {
            return this.constructedSet;
        }
        if (this.leastUpperBound == TypeFactory.getInstance().voidType() || this.builder == null) {
            this.constructedSet = EmptySet.EMPTY_SET;
            return this.constructedSet;
        }
        this.constructedSet = this.builder.done();
        return this.constructedSet;
    }

    public static <T, R> Function<T, R> asInstanceOf(Class<R> resultClass) {
        return item -> item;
    }

    public static <T> Predicate<T> isInstanceOf(Class<T> inputClass) {
        return item -> inputClass.isInstance(item);
    }

    private void checkMutation() {
        if (this.constructedSet != null) {
            throw new UnsupportedOperationException("Mutation of a finalized set is not supported.");
        }
    }

    public String toString() {
        if (this.builder == null) {
            return "{}";
        }
        return this.builder.toString();
    }

    @Override
    public void insertTuple(IValue ... fields) {
        this.insert(Tuple.newTuple(fields));
    }

    @Override
    public Iterator<IValue> iterator() {
        if (this.builder == null) {
            return Collections.emptyIterator();
        }
        return this.builder.iterator();
    }

    @Override
    public Supplier<IWriter<ISet>> supplier() {
        return () -> ValueFactory.getInstance().setWriter();
    }

    private static final class MultiMapBuilder
    implements Builder {
        AbstractTypeBag keyTypeBag = AbstractTypeBag.of(new Type[0]);
        AbstractTypeBag valTypeBag = AbstractTypeBag.of(new Type[0]);
        SetMultimap.Transient<IValue, IValue> map = SetMultimap.Transient.of();

        private MultiMapBuilder() {
        }

        @Override
        public void put(IValue element, Type elementType) {
            IValue value;
            IValue key = ((ITuple)element).get(0);
            if (this.map.__insert(key, value = ((ITuple)element).get(1))) {
                this.keyTypeBag = this.keyTypeBag.increase(elementType.getFieldType(0));
                this.valTypeBag = this.valTypeBag.increase(elementType.getFieldType(1));
            }
        }

        @Override
        public ISet done() {
            return PersistentSetFactory.from(this.keyTypeBag, this.valTypeBag, this.map.freeze());
        }

        @Override
        public Iterator<IValue> iterator() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{");
            Iterator keys = this.map.keyIterator();
            while (keys.hasNext()) {
                IValue key = (IValue)keys.next();
                for (IValue val : this.map.get(key)) {
                    b.append("<");
                    b.append(key);
                    b.append(",");
                    b.append(val);
                    b.append(">");
                }
            }
            b.append("}");
            return b.toString();
        }
    }

    private static final class SetBuilder
    implements Builder {
        private final Set.Transient<IValue> set = Set.Transient.of();
        private AbstractTypeBag elementTypeBag = AbstractTypeBag.of(new Type[0]);

        private SetBuilder() {
        }

        @Override
        public void put(IValue element, Type elementType) {
            if (this.set.__insert(element)) {
                this.elementTypeBag = this.elementTypeBag.increase(elementType);
            }
        }

        @Override
        public ISet done() {
            return PersistentSetFactory.from(this.elementTypeBag, this.set.freeze());
        }

        @Override
        public Iterator<IValue> iterator() {
            return this.set.iterator();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{");
            for (IValue e : this) {
                b.append(e.toString());
                b.append(",");
            }
            b.append("}");
            return b.toString();
        }
    }

    private static interface Builder
    extends Iterable<IValue> {
        public void put(IValue var1, Type var2);

        public ISet done();
    }
}

