/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import com.github.luben.zstd.ZstdDirectBufferDecompressingStream;
import io.usethesource.vallang.io.binary.util.ByteBufferInputStream;
import io.usethesource.vallang.io.binary.util.DirectByteBufferCache;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DirectZstdInputStream
extends ByteBufferInputStream {
    private final ByteBufferInputStream orginalStream;
    private ZstdDirectBufferDecompressingStream decompressor;
    private boolean closed = false;

    public DirectZstdInputStream(ByteBufferInputStream originalStream) {
        super(DirectZstdInputStream.constructDecompressedBuffer(originalStream));
        this.orginalStream = originalStream;
        this.decompressor = new ZstdDirectBufferDecompressingStream(originalStream.getByteBuffer());
    }

    @Override
    protected ByteBuffer refill(ByteBuffer torefill) throws IOException {
        torefill.clear();
        this.decompressor.read(torefill);
        torefill.flip();
        return torefill;
    }

    private static ByteBuffer constructDecompressedBuffer(ByteBufferInputStream oriStream) {
        int compressedSize = oriStream.getByteBuffer().remaining();
        int bufferSize = ZstdDirectBufferDecompressingStream.recommendedTargetBufferSize();
        if (bufferSize > compressedSize) {
            bufferSize = Math.min(compressedSize * 2, bufferSize);
        }
        ByteBuffer result = DirectByteBufferCache.getInstance().get(bufferSize);
        result.limit(0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try (ByteBufferInputStream old = this.orginalStream;){
                super.close();
                this.decompressor.close();
            }
            finally {
                DirectByteBufferCache.getInstance().put(this.source);
            }
        }
    }
}

