/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.vallang.io.binary.util.ByteBufferInputStream;
import io.usethesource.vallang.io.binary.util.DirectByteBufferCache;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileChannelDirectInputStream
extends ByteBufferInputStream {
    private final FileChannel channel;
    private final boolean small;
    private boolean closed = false;
    private static final @MonotonicNonNull MethodHandle INVOKE_CLEANER;
    private static final @MonotonicNonNull Object THE_UNSAFE;

    public FileChannelDirectInputStream(FileChannel channel) throws IOException {
        super(FileChannelDirectInputStream.smallFile(channel) ? FileChannelDirectInputStream.getSmallBuffer(channel) : channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size()));
        this.channel = channel;
        this.small = FileChannelDirectInputStream.smallFile(channel);
    }

    private static ByteBuffer getSmallBuffer(FileChannel channel) throws IOException {
        return DirectByteBufferCache.getInstance().get((int)channel.size()).flip();
    }

    private static boolean smallFile(FileChannel channel) throws IOException {
        return channel.size() < 8192L;
    }

    @Override
    protected ByteBuffer refill(ByteBuffer torefill) throws IOException {
        if (this.small) {
            torefill.clear();
            this.channel.read(torefill);
            torefill.flip();
        }
        return torefill;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try (FileChannel chan = this.channel;){
                if (!this.small) {
                    FileChannelDirectInputStream.closeDirectBuffer(this.source);
                } else {
                    DirectByteBufferCache.getInstance().put(this.source);
                }
            }
        }
    }

    private static void closeDirectBuffer(@Nullable ByteBuffer cb) {
        if (cb == null || !cb.isDirect()) {
            return;
        }
        if (INVOKE_CLEANER != null && THE_UNSAFE != null) {
            try {
                INVOKE_CLEANER.invoke(THE_UNSAFE, cb);
            }
            catch (Throwable e) {
                System.err.println(FileChannelDirectInputStream.class.getName() + ": error cleaning: " + e);
            }
        } else {
            cb = null;
            System.gc();
        }
    }

    static {
        AtomicReference cleaner = new AtomicReference();
        AtomicReference unsafe = new AtomicReference();
        AccessController.doPrivileged(() -> {
            Class<?> unsafeClass;
            try {
                unsafeClass = Class.forName("sun.misc.Unsafe");
            }
            catch (Exception ex) {
                try {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                catch (Exception e) {
                    unsafeClass = null;
                    System.err.println(FileChannelDirectInputStream.class.getName() + ": cannot locate unsafe class :" + e);
                }
            }
            if (unsafeClass == null) {
                System.err.println(FileChannelDirectInputStream.class.getName() + ": cannot locate unsafe class");
                return null;
            }
            try {
                cleaner.set(MethodHandles.lookup().findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class)));
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object unsafeValue = theUnsafeField.get(null);
                unsafe.set(unsafeValue);
                return null;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                System.err.println(FileChannelDirectInputStream.class.getName() + ": cannot locate unsafe instance or invokeCleaner: " + e);
                cleaner.set(null);
                unsafe.set(null);
                return null;
            }
        });
        INVOKE_CLEANER = (MethodHandle)cleaner.get();
        THE_UNSAFE = unsafe.get();
    }
}

