/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.type.VoidType;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

class SetType
extends DefaultSubtypeOfValue {
    protected final Type fEltType;

    SetType(Type eltType) {
        this.fEltType = eltType;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public Type getElementType() {
        return this.fEltType;
    }

    @Override
    public boolean hasFieldNames() {
        return this.fEltType.hasFieldNames();
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fEltType.hasField(fieldName);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public boolean isRelation() {
        return this.fEltType.isTuple() || this.fEltType.isBottom();
    }

    @Override
    public int getFieldIndex(String fieldName) {
        return this.fEltType.getFieldIndex(fieldName);
    }

    @Override
    public Type getFieldType(int i) {
        return this.fEltType.getFieldType(i);
    }

    @Override
    public String getFieldName(int i) {
        return this.fEltType.getFieldName(i);
    }

    @Override
    public String[] getFieldNames() {
        return this.fEltType.getFieldNames();
    }

    @Override
    public Type getFieldType(String fieldName) throws FactTypeUseException {
        return this.fEltType.getFieldType(fieldName);
    }

    @Override
    public Type getFieldTypes() {
        return this.fEltType.getFieldTypes();
    }

    @Override
    public int getArity() {
        return this.fEltType.getArity();
    }

    @Override
    public Type carrier() {
        return this.fEltType.carrier();
    }

    @Override
    public Type closure() {
        return TF.setType(this.fEltType.closure());
    }

    @Override
    public Type compose(Type other) {
        return TF.setType(this.fEltType.compose(other.getElementType()));
    }

    @Override
    public Type select(int ... fields) {
        return TF.setType(this.fEltType.select(fields));
    }

    @Override
    public Type select(String ... names) {
        return TF.setType(this.fEltType.select(names));
    }

    @Override
    public int hashCode() {
        return 56509 + 3511 * this.fEltType.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof SetType)) {
            return false;
        }
        SetType other = (SetType)obj;
        return this.fEltType == other.fEltType;
    }

    @Override
    public String toString() {
        if (this.fEltType.isFixedWidth() && !this.fEltType.equivalent(VoidType.getInstance())) {
            StringBuilder sb = new StringBuilder();
            sb.append("rel[");
            int idx = 0;
            for (Type elemType : this.fEltType) {
                if (idx++ > 0) {
                    sb.append(",");
                }
                sb.append(elemType.toString());
                if (!this.hasFieldNames()) continue;
                sb.append(" " + this.fEltType.getFieldName(idx - 1));
            }
            sb.append("]");
            return sb.toString();
        }
        return "set[" + this.fEltType + "]";
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitSet(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfSet(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithSet(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithSet(this);
    }

    @Override
    protected Type glbWithSet(Type type) {
        return this == type ? this : TF.setType(this.fEltType.glb(type.getElementType()));
    }

    @Override
    protected boolean isSubtypeOfSet(Type type) {
        return this.fEltType.isSubtypeOf(type.getElementType());
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithSet(this);
    }

    @Override
    protected boolean intersectsWithSet(Type type) {
        return true;
    }

    @Override
    protected Type lubWithSet(Type type) {
        return TF.setType(this.fEltType.lub(type.getElementType()));
    }

    @Override
    public boolean isOpen() {
        return this.fEltType.isOpen();
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (!super.match(matched, bindings)) {
            return false;
        }
        if (matched.isSet() || matched.isAliased() && matched.getAliased().isSet() || matched.isBottom()) {
            return this.getElementType().match(matched.getElementType(), bindings);
        }
        return true;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        return TypeFactory.getInstance().setType(this.getElementType().instantiate(bindings));
    }

    @Override
    public IValue randomValue(Random random, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        ISetWriter result = vf.setWriter();
        if (maxDepth > 0 && random.nextBoolean()) {
            int size = Math.min(maxWidth, 1 + random.nextInt(maxDepth));
            if (!this.getElementType().isBottom()) {
                for (int i = 0; i < size; ++i) {
                    result.insert(this.getElementType().randomValue(random, vf, store, typeParameters, maxDepth, maxWidth));
                }
            }
        }
        ISet done = (ISet)result.done();
        this.match(done.getType(), typeParameters);
        return done;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Type> getSymbolConstructorTypes() {
            return Arrays.stream(new Type[]{this.getSetType(), this.getRelType()}).collect(Collectors.toSet());
        }

        @Override
        public Type randomInstance(Supplier<Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().setType(next.get());
        }

        @Override
        public boolean isRecursive() {
            return false;
        }

        private Type getRelType() {
            return this.symbols().typeSymbolConstructor("rel", this.tf().listType(this.symbols().symbolADT()), "symbols");
        }

        private Type getSetType() {
            return this.symbols().typeSymbolConstructor("set", this.symbols().symbolADT(), "symbol");
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            if (symbol.getConstructorType() == this.getSetType()) {
                return this.tf().setType(this.symbols().fromSymbol((IConstructor)symbol.get("symbol"), store, grammar));
            }
            return this.tf().setType(this.symbols().fromSymbols((IList)symbol.get("symbols"), store, grammar));
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            return vf.constructor(this.getSetType(), type.getElementType().asSymbol(vf, store, grammar, done));
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            type.getElementType().asProductions(vf, store, grammar, done);
        }
    }
}

